/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import javax.swing.JComponent;

public class PickingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected Vertex vertex;
    protected Edge edge;
    protected double offsetx;
    protected double offsety;
    protected boolean locked;
    protected int addToSelectionModifiers;
    protected Rectangle2D rect = new Rectangle2D.Float();
    protected VisualizationViewer.Paintable lensPaintable;
    protected Color lensColor = Color.cyan;

    public PickingGraphMousePlugin() {
        this(16, 17);
    }

    public PickingGraphMousePlugin(int selectionModifiers, int addToSelectionModifiers) {
        super(selectionModifiers);
        this.addToSelectionModifiers = addToSelectionModifiers;
        this.lensPaintable = new LensPaintable();
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    public Color getLensColor() {
        return this.lensColor;
    }

    public void setLensColor(Color lensColor) {
        this.lensColor = lensColor;
    }

    public void mousePressed(MouseEvent e) {
        this.down = e.getPoint();
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        PickSupport pickSupport = vv.getPickSupport();
        PickedState pickedState = vv.getPickedState();
        if (pickSupport != null && pickedState != null) {
            Layout layout = vv.getGraphLayout();
            if (e.getModifiers() == this.modifiers) {
                vv.addPostRenderPaintable(this.lensPaintable);
                this.rect.setFrameFromDiagonal(this.down, this.down);
                Point p = e.getPoint();
                Point2D ip = vv.inverseViewTransform(p);
                this.vertex = pickSupport.getVertex(ip.getX(), ip.getY());
                if (this.vertex != null) {
                    if (!pickedState.isPicked(this.vertex)) {
                        pickedState.clearPickedVertices();
                        pickedState.pick(this.vertex, true);
                    }
                    Point2D q = layout.getLocation(this.vertex);
                    Point2D gp = vv.inverseLayoutTransform(ip);
                    this.offsetx = (float)(gp.getX() - q.getX());
                    this.offsety = (float)(gp.getY() - q.getY());
                } else {
                    this.edge = pickSupport.getEdge(ip.getX(), ip.getY());
                    if (this.edge != null) {
                        pickedState.clearPickedEdges();
                        pickedState.pick(this.edge, true);
                    } else {
                        pickedState.clearPickedEdges();
                        pickedState.clearPickedVertices();
                    }
                }
            } else if (e.getModifiers() == this.addToSelectionModifiers) {
                vv.addPostRenderPaintable(this.lensPaintable);
                this.rect.setFrameFromDiagonal(this.down, this.down);
                Point p = e.getPoint();
                Point2D ip = vv.inverseViewTransform(p);
                this.vertex = pickSupport.getVertex(ip.getX(), ip.getY());
                if (this.vertex != null) {
                    boolean wasThere = pickedState.pick(this.vertex, !pickedState.isPicked(this.vertex));
                    if (wasThere) {
                        this.vertex = null;
                    } else {
                        Point2D q = layout.getLocation(this.vertex);
                        Point2D gp = vv.inverseLayoutTransform(ip);
                        this.offsetx = (float)(gp.getX() - q.getX());
                        this.offsety = (float)(gp.getY() - q.getY());
                    }
                } else {
                    this.edge = pickSupport.getEdge(ip.getX(), ip.getY());
                    if (this.edge != null) {
                        pickedState.pick(this.edge, !pickedState.isPicked(this.edge));
                    }
                }
            }
        }
        if (this.vertex != null) {
            e.consume();
        }
    }

    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        if (e.getModifiers() == this.modifiers) {
            if (this.down != null) {
                Point out = e.getPoint();
                if (this.vertex == null && !this.heyThatsTooClose(this.down, out, 5.0)) {
                    this.pickContainedVertices(vv, true);
                }
            }
        } else if (e.getModifiers() == this.addToSelectionModifiers && this.down != null) {
            Point out = e.getPoint();
            if (this.vertex == null && !this.heyThatsTooClose(this.down, out, 5.0)) {
                this.pickContainedVertices(vv, false);
            }
        }
        this.down = null;
        this.vertex = null;
        this.edge = null;
        this.rect.setFrame(0.0, 0.0, 0.0, 0.0);
        vv.removePostRenderPaintable(this.lensPaintable);
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.locked) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            if (this.vertex != null) {
                Point p = e.getPoint();
                Point2D graphPoint = vv.inverseTransform(p);
                Point2D graphDown = vv.inverseTransform(this.down);
                Layout layout = vv.getGraphLayout();
                double dx = graphPoint.getX() - graphDown.getX();
                double dy = graphPoint.getY() - graphDown.getY();
                PickedState ps = vv.getPickedState();
                Iterator iterator = ps.getPickedVertices().iterator();
                while (iterator.hasNext()) {
                    Vertex v = (Vertex)iterator.next();
                    Point2D vp = layout.getLocation(v);
                    layout.forceMove(v, vp.getX() + dx, vp.getY() + dy);
                }
                this.down = p;
            } else {
                Point out = e.getPoint();
                if (e.getModifiers() == this.addToSelectionModifiers || e.getModifiers() == this.modifiers) {
                    this.rect.setFrameFromDiagonal(this.down, out);
                }
            }
            if (this.vertex != null) {
                e.consume();
            }
        }
    }

    private boolean heyThatsTooClose(Point2D p, Point2D q, double min) {
        return Math.abs(p.getX() - q.getX()) < min && Math.abs(p.getY() - q.getY()) < min;
    }

    protected void pickContainedVertices(VisualizationViewer vv, boolean clear) {
        Layout layout = vv.getGraphLayout();
        PickedState pickedState = vv.getPickedState();
        if (pickedState != null) {
            if (clear) {
                pickedState.clearPickedVertices();
            }
            while (true) {
                try {
                    Iterator iter = layout.getGraph().getVertices().iterator();
                    while (iter.hasNext()) {
                        Vertex v = (Vertex)iter.next();
                        if (!this.rect.contains(vv.transform(layout.getLocation(v)))) continue;
                        pickedState.pick(v, true);
                    }
                }
                catch (ConcurrentModificationException cme) {
                    continue;
                }
                break;
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseMoved(MouseEvent e) {
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    class LensPaintable
    implements VisualizationViewer.Paintable {
        LensPaintable() {
        }

        public void paint(Graphics g) {
            Color oldColor = g.getColor();
            g.setColor(PickingGraphMousePlugin.this.lensColor);
            ((Graphics2D)g).draw(PickingGraphMousePlugin.this.rect);
            g.setColor(oldColor);
        }

        public boolean useTransform() {
            return false;
        }
    }
}

