/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ModalSatelliteGraphMouse;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class SatelliteVisualizationViewer
extends VisualizationViewer {
    protected VisualizationViewer master;

    public SatelliteVisualizationViewer(VisualizationViewer master, Layout layout, Renderer renderer) {
        this(master, new DefaultVisualizationModel(layout), renderer);
    }

    public SatelliteVisualizationViewer(VisualizationViewer master, Layout layout, Renderer renderer, Dimension preferredSize) {
        this(master, new DefaultVisualizationModel(layout, preferredSize), renderer, preferredSize);
    }

    public SatelliteVisualizationViewer(VisualizationViewer master, VisualizationModel model, Renderer renderer) {
        this(master, model, renderer, new Dimension(300, 300));
    }

    public SatelliteVisualizationViewer(VisualizationViewer master, VisualizationModel model, Renderer renderer, Dimension preferredSize) {
        super(model, renderer, preferredSize);
        this.master = master;
        ModalSatelliteGraphMouse gm = new ModalSatelliteGraphMouse();
        this.setGraphMouse(gm);
        this.addPreRenderPaintable(new ViewLens(this, master));
        AffineTransform modelLayoutTransform = new AffineTransform(master.getLayoutTransformer().getTransform());
        this.setLayoutTransformer(new MutableAffineTransformer(modelLayoutTransform));
        master.addChangeListener(this);
        this.setPickedState(master.getPickedState());
        this.setPickSupport(new ShapePickSupport());
    }

    public VisualizationViewer getMaster() {
        return this.master;
    }

    static class ViewLens
    implements VisualizationViewer.Paintable {
        VisualizationViewer master;
        VisualizationViewer vv;

        public ViewLens(VisualizationViewer vv, VisualizationViewer master) {
            this.vv = vv;
            this.master = master;
        }

        public void paint(Graphics g) {
            MutableTransformer masterViewTransformer = this.master.getViewTransformer();
            MutableTransformer masterLayoutTransformer = this.master.getLayoutTransformer();
            MutableTransformer vvLayoutTransformer = this.vv.getLayoutTransformer();
            Shape lens = this.master.getBounds();
            lens = masterViewTransformer.inverseTransform(lens);
            lens = masterLayoutTransformer.inverseTransform(lens);
            lens = vvLayoutTransformer.transform(lens);
            Graphics2D g2d = (Graphics2D)g;
            Color old = g.getColor();
            Color lensColor = this.master.getBackground();
            this.vv.setBackground(lensColor.darker());
            g.setColor(lensColor);
            g2d.fill(lens);
            g.setColor(Color.gray);
            g2d.draw(lens);
            g.setColor(old);
        }

        public boolean useTransform() {
            return true;
        }
    }
}

