/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.iter;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import java.util.Iterator;
import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.iter.IterableLayout;

public class GraphLayoutPanelUtils {
    public static void prerelax(long millis, IterableLayout la) {
        long timeNow = System.currentTimeMillis();
        while (System.currentTimeMillis() - timeNow < millis) {
            la.advance();
        }
    }

    public static EmittedLayout copy(EmittedLayout dest, EmittedLayout layoutToCopy) {
        dest.screenSize.setSize(layoutToCopy.screenSize);
        dest.visEdgeMap.clear();
        dest.visVertexMap.clear();
        Iterator iter = layoutToCopy.visVertexMap.values().iterator();
        while (iter.hasNext()) {
            VisVertex vv = (VisVertex)iter.next();
            Vertex v = vv.getVertex();
            dest.visVertexMap.put(v, vv.copy());
        }
        iter = layoutToCopy.visEdgeMap.values().iterator();
        while (iter.hasNext()) {
            VisEdge ve = (VisEdge)iter.next();
            Edge e = ve.getEdge();
            Pair p = e.getEndpoints();
            VisVertex front = dest.getVisVertex((Vertex)p.getFirst());
            VisVertex back = dest.getVisVertex((Vertex)p.getSecond());
            dest.visEdgeMap.put(e, ve.copy(front, back));
        }
        return dest;
    }

    public static EmittedLayout copy(EmittedLayout layoutToCopy) {
        EmittedLayout sl = new EmittedLayout();
        return GraphLayoutPanelUtils.copy(sl, layoutToCopy);
    }
}

