/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EdgeClusterSet
extends ClusterSet {
    public EdgeClusterSet(Graph underlyingGraph) {
        super(underlyingGraph);
    }

    public Graph getClusterAsNewSubGraph(int index) {
        return GraphUtils.edgeSetToGraph(this.getCluster(index), true);
    }

    public ClusterSet createEquivalentClusterSet(Graph anotherGraph) {
        EdgeClusterSet newClusterSet = new EdgeClusterSet(anotherGraph);
        Iterator cIt = this.iterator();
        while (cIt.hasNext()) {
            Set cluster = (Set)cIt.next();
            HashSet<ArchetypeEdge> newCluster = new HashSet<ArchetypeEdge>();
            Iterator udcIt = cluster.iterator();
            while (udcIt.hasNext()) {
                ArchetypeEdge edge = (ArchetypeEdge)udcIt.next();
                ArchetypeEdge equivalentEdge = edge.getEqualEdge(anotherGraph);
                if (equivalentEdge == null) {
                    throw new IllegalArgumentException("Can not create equivalent cluster set because equivalent edges could not be found in the other graph.");
                }
                newCluster.add(equivalentEdge);
            }
            newClusterSet.addCluster(newCluster);
        }
        return newClusterSet;
    }
}

