/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.filters;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.filters.EfficientFilter;
import edu.uci.ics.jung.graph.filters.Filter;
import edu.uci.ics.jung.graph.filters.UnassembledGraph;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class GeneralVertexAcceptFilter
implements Filter {
    public abstract boolean acceptVertex(Vertex var1);

    public UnassembledGraph filter(Graph g) {
        Set vertices = this.chooseGoodVertices(g.getVertices());
        Set edges = g.getEdges();
        return new UnassembledGraph((Filter)this, vertices, edges, g);
    }

    public UnassembledGraph filter(UnassembledGraph g) {
        if (!(this instanceof EfficientFilter)) {
            throw new FatalException("Do not call non-efficient filters with UnassembledGraphs.");
        }
        Set vertices = this.chooseGoodVertices(g.getUntouchedVertices());
        Set edges = g.getUntouchedEdges();
        return new UnassembledGraph((Filter)this, vertices, edges, g);
    }

    private Set chooseGoodVertices(Set vertices) {
        HashSet<Vertex> newVertices = new HashSet<Vertex>();
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            Vertex e = (Vertex)iter.next();
            if (!this.acceptVertex(e)) continue;
            newVertices.add(e);
        }
        return newVertices;
    }
}

