/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.filters;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.filters.UnassembledGraph;

public class GraphAssemblyRecord {
    public static final Object FILTER_GRAPH_KEY = "edu.uci.ics.jung.filter.UnassembledGraph_FilterData";
    private String name;
    private Graph originalGraph;

    GraphAssemblyRecord(UnassembledGraph graph) {
        this.originalGraph = graph.getOriginalGraph();
        this.name = graph.getFilterName();
    }

    public Graph getOriginalGraph() {
        return this.originalGraph;
    }

    public String getName() {
        return this.name;
    }

    public GraphAssemblyRecord getPreviousAssemblyRecord() {
        GraphAssemblyRecord gar = (GraphAssemblyRecord)this.originalGraph.getUserDatum(FILTER_GRAPH_KEY);
        return gar;
    }

    public String getNameExtended() {
        if (this.getPreviousAssemblyRecord() != null) {
            return this.name + ":::" + this.getPreviousAssemblyRecord().getNameExtended();
        }
        return this.name;
    }

    public Graph getOriginalExtended() {
        if (this.getPreviousAssemblyRecord() != null) {
            return this.getPreviousAssemblyRecord().getOriginalExtended();
        }
        return this.originalGraph;
    }

    public static GraphAssemblyRecord getAssemblyRecord(Graph g) {
        GraphAssemblyRecord gar = (GraphAssemblyRecord)g.getUserDatum(FILTER_GRAPH_KEY);
        return gar;
    }
}

