/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Hyperedge;
import edu.uci.ics.jung.graph.Hypervertex;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.AbstractHyperUnitBPG;
import edu.uci.ics.jung.graph.impl.BipartiteVertex;
import edu.uci.ics.jung.graph.impl.HyperedgeBPG;
import edu.uci.ics.jung.graph.impl.HypergraphBPG;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HypervertexBPG
extends AbstractHyperUnitBPG
implements Hypervertex {
    public HypervertexBPG() {
    }

    HypervertexBPG(BipartiteVertex bpv, HypergraphBPG hypergraphBPG) {
        super(bpv, hypergraphBPG);
    }

    public Set getIncidentElements() {
        return this.getIncidentEdges();
    }

    public Set getNeighbors() {
        Set oldNeighbors = this.vertex.getNeighbors();
        HashSet realNeighbors = new HashSet();
        Iterator iter = oldNeighbors.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            realNeighbors.addAll(v.getNeighbors());
        }
        realNeighbors.remove(this.vertex);
        return this.graph.translateUnderlyingVertices(realNeighbors);
    }

    public Set getIncidentEdges() {
        return this.graph.translateUnderlyingEdges(this.vertex.getNeighbors());
    }

    public int degree() {
        return this.vertex.degree();
    }

    public ArchetypeVertex getEqualVertex(ArchetypeGraph g) {
        HypergraphBPG bpg = (HypergraphBPG)g;
        return bpg.getVertexCorrespondingTo(this.underlying_vertex());
    }

    public ArchetypeVertex getEquivalentVertex(ArchetypeGraph g) {
        return this.getEqualVertex(g);
    }

    public boolean isNeighborOf(ArchetypeVertex v) {
        return this.getNeighbors().contains(v);
    }

    public boolean isIncident(ArchetypeEdge e) {
        HyperedgeBPG hepbg = (HyperedgeBPG)e;
        return this.underlying_vertex().isNeighborOf(hepbg.underlying_vertex());
    }

    public ArchetypeEdge findEdge(ArchetypeVertex v) {
        Set incident_edges = this.getIncidentEdges();
        Iterator iter = incident_edges.iterator();
        while (iter.hasNext()) {
            ArchetypeEdge e = (ArchetypeEdge)iter.next();
            if (!e.isIncident(v)) continue;
            return e;
        }
        return null;
    }

    public Set findEdgeSet(ArchetypeVertex v) {
        Set incident_edges = this.getIncidentEdges();
        HashSet<ArchetypeEdge> connecting_edges = new HashSet<ArchetypeEdge>();
        Iterator iter = incident_edges.iterator();
        while (iter.hasNext()) {
            ArchetypeEdge e = (ArchetypeEdge)iter.next();
            if (!e.isIncident(v)) continue;
            connecting_edges.add(e);
        }
        return connecting_edges;
    }

    public int numNeighbors() {
        return this.getNeighbors().size();
    }

    public ArchetypeVertex copy(ArchetypeGraph g) {
        HypergraphBPG hg = (HypergraphBPG)g;
        HypervertexBPG hv = new HypervertexBPG();
        hg.addVertex(hv);
        hv.importUserData(this);
        return hv;
    }

    public boolean connectEdge(Hyperedge e) {
        return e.connectVertex(this);
    }

    public boolean disconnectEdge(Hyperedge e) {
        return e.disconnectVertex(this);
    }
}

