/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.predicates;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.predicates.EdgePredicate;
import edu.uci.ics.jung.utils.Pair;
import java.util.Iterator;
import java.util.Set;

public class ParallelEdgePredicate
extends EdgePredicate {
    private static ParallelEdgePredicate instance;
    private static final String message = "ParallelEdgePredicate";

    protected ParallelEdgePredicate() {
    }

    public static ParallelEdgePredicate getInstance() {
        if (instance == null) {
            instance = new ParallelEdgePredicate();
        }
        return instance;
    }

    public String toString() {
        return message;
    }

    public boolean evaluateEdge(ArchetypeEdge ae) {
        Edge e = (Edge)ae;
        Pair endpoints = e.getEndpoints();
        Vertex u = (Vertex)endpoints.getFirst();
        Vertex v = (Vertex)endpoints.getSecond();
        Set s = u.findEdgeSet(v);
        if (this.isDirected(e)) {
            return this.evaluateDirectedEdge((DirectedEdge)e, s.iterator());
        }
        return this.evaluateUndirectedEdge((UndirectedEdge)e, s.iterator());
    }

    protected boolean evaluateDirectedEdge(DirectedEdge de, Iterator s_iter) {
        while (s_iter.hasNext()) {
            DirectedEdge df;
            Edge f = (Edge)s_iter.next();
            if (de == f || !this.isDirected(f) || (df = (DirectedEdge)f).getSource() != de.getSource() || df.getDest() != de.getDest()) continue;
            return true;
        }
        return false;
    }

    protected boolean evaluateUndirectedEdge(UndirectedEdge ue, Iterator s_iter) {
        while (s_iter.hasNext()) {
            Edge f = (Edge)s_iter.next();
            if (ue == f || this.isDirected(f) || !((Object)f.getIncidentVertices()).equals(ue.getIncidentVertices())) continue;
            return true;
        }
        return false;
    }

    protected boolean isDirected(Edge e) {
        if (e instanceof DirectedEdge) {
            return true;
        }
        if (e instanceof UndirectedEdge) {
            return false;
        }
        throw new IllegalArgumentException(e + "is neither directed nor undirected");
    }
}

