/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.Intersector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphZoomScrollPane
extends JPanel {
    protected VisualizationViewer vv;
    protected JScrollBar horizontalScrollBar;
    protected JScrollBar verticalScrollBar;
    protected JComponent corner;
    protected boolean scrollBarsMayControlAdjusting = true;
    protected JPanel south;

    public GraphZoomScrollPane(VisualizationViewer vv) {
        super(new BorderLayout());
        this.vv = vv;
        this.addComponentListener(new ResizeListener());
        Dimension d = vv.getGraphLayout().getCurrentSize();
        this.verticalScrollBar = new JScrollBar(1, 0, d.height, 0, d.height);
        this.horizontalScrollBar = new JScrollBar(0, 0, d.width, 0, d.width);
        this.verticalScrollBar.addAdjustmentListener(new VerticalAdjustmentListenerImpl());
        this.horizontalScrollBar.addAdjustmentListener(new HorizontalAdjustmentListenerImpl());
        this.verticalScrollBar.setUnitIncrement(20);
        this.horizontalScrollBar.setUnitIncrement(20);
        vv.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                VisualizationViewer vv = (VisualizationViewer)evt.getSource();
                GraphZoomScrollPane.this.setScrollBars(vv);
            }
        });
        this.add(vv);
        this.add((Component)this.verticalScrollBar, "East");
        this.south = new JPanel(new BorderLayout());
        this.south.add(this.horizontalScrollBar);
        this.setCorner(new JPanel());
        this.add((Component)this.south, "South");
    }

    private void setScrollBars(VisualizationViewer vv) {
        Dimension d = vv.getGraphLayout().getCurrentSize();
        Rectangle vvBounds = vv.getBounds();
        Rectangle layoutRectangle = new Rectangle(0, 0, d.width, d.height);
        MutableTransformer viewTransformer = vv.getViewTransformer();
        MutableTransformer layoutTransformer = vv.getLayoutTransformer();
        Point2D h0 = new Point2D.Double(vvBounds.getMinX(), vvBounds.getCenterY());
        Point2D h1 = new Point2D.Double(vvBounds.getMaxX(), vvBounds.getCenterY());
        Point2D v0 = new Point2D.Double(vvBounds.getCenterX(), vvBounds.getMinY());
        Point2D v1 = new Point2D.Double(vvBounds.getCenterX(), vvBounds.getMaxY());
        h0 = viewTransformer.inverseTransform(h0);
        h0 = layoutTransformer.inverseTransform(h0);
        h1 = viewTransformer.inverseTransform(h1);
        h1 = layoutTransformer.inverseTransform(h1);
        v0 = viewTransformer.inverseTransform(v0);
        v0 = layoutTransformer.inverseTransform(v0);
        v1 = viewTransformer.inverseTransform(v1);
        v1 = layoutTransformer.inverseTransform(v1);
        this.scrollBarsMayControlAdjusting = false;
        this.setScrollBarValues(layoutRectangle, h0, h1, v0, v1);
        this.scrollBarsMayControlAdjusting = true;
    }

    protected void setScrollBarValues(Rectangle rectangle, Point2D h0, Point2D h1, Point2D v0, Point2D v1) {
        int ext;
        int max;
        Point2D temp;
        boolean containsH0 = rectangle.contains(h0);
        boolean containsH1 = rectangle.contains(h1);
        boolean containsV0 = rectangle.contains(v0);
        boolean containsV1 = rectangle.contains(v1);
        Intersector intersector = new Intersector(rectangle, new Line2D.Double(h0, h1));
        int min = 0;
        int val = 0;
        Set points = intersector.getPoints();
        Point2D first = null;
        Point2D second = null;
        Point2D[] pointArray = points.toArray(new Point2D[points.size()]);
        if (pointArray.length > 1) {
            first = pointArray[0];
            second = pointArray[1];
        } else if (pointArray.length > 0) {
            first = second = pointArray[0];
        }
        if (first != null && second != null) {
            if ((h0.getX() - h1.getX()) * (first.getX() - second.getX()) < 0.0) {
                temp = first;
                first = second;
                second = temp;
            }
            if (containsH0 && containsH1) {
                max = (int)first.distance(second);
                val = (int)first.distance(h0);
                ext = (int)h0.distance(h1);
            } else if (containsH0) {
                max = (int)first.distance(second);
                val = (int)first.distance(h0);
                ext = (int)h0.distance(second);
            } else if (containsH1) {
                max = (int)first.distance(second);
                val = 0;
                ext = (int)first.distance(h1);
            } else {
                max = ext = rectangle.width;
                val = min;
            }
            this.horizontalScrollBar.setValues(val, ext + 1, min, max);
        }
        val = 0;
        min = 0;
        intersector.intersectLine(new Line2D.Double(v0, v1));
        points = intersector.getPoints();
        pointArray = points.toArray(new Point2D[points.size()]);
        if (pointArray.length > 1) {
            first = pointArray[0];
            second = pointArray[1];
        } else if (pointArray.length > 0) {
            first = second = pointArray[0];
        }
        if (first != null && second != null) {
            if ((v0.getY() - v1.getY()) * (first.getY() - second.getY()) < 0.0) {
                temp = first;
                first = second;
                second = temp;
            }
            if (containsV0 && containsV1) {
                max = (int)first.distance(second);
                val = (int)first.distance(v0);
                ext = (int)v0.distance(v1);
            } else if (containsV0) {
                max = (int)first.distance(second);
                val = (int)first.distance(v0);
                ext = (int)v0.distance(second);
            } else if (containsV1) {
                max = (int)first.distance(second);
                val = 0;
                ext = (int)first.distance(v1);
            } else {
                max = ext = rectangle.height;
                val = min;
            }
            this.verticalScrollBar.setValues(val, ext + 1, min, max);
        }
    }

    public JComponent getCorner() {
        return this.corner;
    }

    public void setCorner(JComponent corner) {
        this.corner = corner;
        corner.setPreferredSize(new Dimension(this.verticalScrollBar.getPreferredSize().width, this.horizontalScrollBar.getPreferredSize().height));
        this.south.add((Component)this.corner, "East");
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    protected class ResizeListener
    extends ComponentAdapter {
        protected ResizeListener() {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            GraphZoomScrollPane.this.setScrollBars(GraphZoomScrollPane.this.vv);
        }

        public void componentShown(ComponentEvent e) {
        }
    }

    class VerticalAdjustmentListenerImpl
    implements AdjustmentListener {
        int previous = 0;

        VerticalAdjustmentListenerImpl() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            JScrollBar sb = (JScrollBar)e.getSource();
            BoundedRangeModel m = sb.getModel();
            int vval = m.getValue();
            float dv = this.previous - vval;
            this.previous = vval;
            if (dv != 0.0f && GraphZoomScrollPane.this.scrollBarsMayControlAdjusting) {
                float layoutScale = (float)GraphZoomScrollPane.this.vv.getLayoutTransformer().getScale();
                AffineTransform at = AffineTransform.getTranslateInstance(0.0, dv *= layoutScale);
                GraphZoomScrollPane.this.vv.getLayoutTransformer().preConcatenate(at);
            }
        }
    }

    class HorizontalAdjustmentListenerImpl
    implements AdjustmentListener {
        int previous = 0;

        HorizontalAdjustmentListenerImpl() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            int hval = e.getValue();
            float dh = this.previous - hval;
            this.previous = hval;
            if (dh != 0.0f && GraphZoomScrollPane.this.scrollBarsMayControlAdjusting) {
                float layoutScale = (float)GraphZoomScrollPane.this.vv.getLayoutTransformer().getScale();
                AffineTransform at = AffineTransform.getTranslateInstance(dh *= layoutScale, 0.0);
                GraphZoomScrollPane.this.vv.getLayoutTransformer().preConcatenate(at);
            }
        }
    }
}

