/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.algorithms.importance.BetweennessCentrality;
import edu.uci.ics.jung.algorithms.importance.DegreeDistributionRanker;
import edu.uci.ics.jung.algorithms.importance.PageRankWithPriors;
import edu.uci.ics.jung.algorithms.importance.Ranking;
import edu.uci.ics.jung.algorithms.transformation.DirectionTransformer;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.filters.impl.NumericDecorationFilter;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.io.PajekNetReader;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import samples.graph.BasicRenderer;

public class RankingDemo
extends JPanel {
    private Graph mCurrentGraph;
    private Layout mVisualizer;
    private BasicRenderer mRenderer;
    private VisualizationViewer mVizViewer;
    private JSlider mNodeAcceptBetweennessSlider;
    private JSlider mNodeSizeDegreeSlider;
    private JSlider mNodeSizePageRankSlider;
    private NumericDecorationFilter mBetweennessFilter;
    private String mLabel;

    public RankingDemo(Graph g) throws HeadlessException {
        this.initialize();
        this.displayGraph(g);
        this.mLabel = "P Smyth";
        Vertex start = StringLabeller.getLabeller(this.mCurrentGraph, "jung.io.PajekNetReader.LABEL").getVertex(this.mLabel);
        this.recalculate(g, start, true);
    }

    protected void initialize() {
        this.createControlsPanel();
        this.mBetweennessFilter = new NumericDecorationFilter();
        this.mBetweennessFilter.setThreshold(0.05);
        this.mBetweennessFilter.setDecorationKey("centrality.BetweennessCentrality");
    }

    private void createControlsPanel() {
        this.setLayout(new BorderLayout());
        JPanel controlsPanel = new JPanel();
        BoxLayout layoutMgr = new BoxLayout(controlsPanel, 3);
        controlsPanel.setPreferredSize(new Dimension(200, 400));
        controlsPanel.setLayout(layoutMgr);
        controlsPanel.setBackground(Color.WHITE);
        this.add((Component)controlsPanel, "East");
        controlsPanel.add(this.createSizePanel());
        controlsPanel.add(this.createFilterPanel());
        this.mNodeSizeDegreeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RankingDemo.this.mRenderer.setSizeKey("jung.algorithms.importance.DegreeDistributionRanker.RankScore");
                RankingDemo.this.mRenderer.setNodeSizeScale(RankingDemo.this.mNodeSizeDegreeSlider.getValue());
                RankingDemo.this.repaint();
            }
        });
        this.mNodeSizePageRankSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RankingDemo.this.mRenderer.setSizeKey("jung.algorithms.importance.PageRank.RankScore");
                RankingDemo.this.mRenderer.setNodeSizeScale(RankingDemo.this.mNodeSizePageRankSlider.getValue());
                RankingDemo.this.repaint();
            }
        });
        this.mNodeAcceptBetweennessSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int val = RankingDemo.this.mNodeAcceptBetweennessSlider.getValue();
                RankingDemo.this.mBetweennessFilter.setThreshold(val);
                Graph newGraph = RankingDemo.this.mBetweennessFilter.filter(RankingDemo.this.mCurrentGraph).assemble();
                RankingDemo.this.mVisualizer.applyFilter(newGraph);
                try {
                    GraphUtils.copyLabels(StringLabeller.getLabeller(RankingDemo.this.mCurrentGraph), StringLabeller.getLabeller(newGraph));
                    Vertex v = StringLabeller.getLabeller(newGraph).getVertex(RankingDemo.this.mLabel);
                    RankingDemo.this.recalculate(newGraph, v, false);
                }
                catch (StringLabeller.UniqueLabelException e1) {
                    // empty catch block
                }
                RankingDemo.this.repaint();
            }
        });
        JButton scramble = new JButton("Redo layout");
        controlsPanel.add(scramble);
        scramble.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                RankingDemo.this.mVisualizer.restart();
                RankingDemo.this.mVizViewer.prerelax();
                RankingDemo.this.mVizViewer.repaint();
            }
        });
        controlsPanel.revalidate();
        controlsPanel.repaint();
    }

    private Component createFilterPanel() {
        MyJPanel jp = new MyJPanel("Filter nodes", Color.RED);
        jp.add(new JLabel("Betweenness:"));
        this.mNodeAcceptBetweennessSlider = new JSlider(0);
        this.mNodeAcceptBetweennessSlider.setPreferredSize(new Dimension(180, 40));
        this.mNodeAcceptBetweennessSlider.setValue(0);
        this.mNodeAcceptBetweennessSlider.setPaintTicks(true);
        this.mNodeAcceptBetweennessSlider.setBackground(Color.WHITE);
        jp.add(this.mNodeAcceptBetweennessSlider);
        return jp;
    }

    private Component createSizePanel() {
        ButtonGroup buttons = new ButtonGroup();
        MyJPanel jp = new MyJPanel("Node Size", Color.RED);
        this.mNodeSizeDegreeSlider = new JSlider(0);
        this.mNodeSizeDegreeSlider.setPreferredSize(new Dimension(180, 40));
        this.mNodeSizeDegreeSlider.setPaintTicks(true);
        this.mNodeSizeDegreeSlider.setBackground(Color.WHITE);
        this.mNodeSizeDegreeSlider.setValue(0);
        final JRadioButton degree = new JRadioButton("Degree");
        degree.setBackground(Color.WHITE);
        degree.setSelected(true);
        buttons.add(degree);
        jp.add(degree);
        jp.add(this.mNodeSizeDegreeSlider);
        this.mNodeSizePageRankSlider = new JSlider(0);
        this.mNodeSizePageRankSlider.setPreferredSize(new Dimension(180, 40));
        this.mNodeSizePageRankSlider.setPaintTicks(true);
        this.mNodeSizePageRankSlider.setBackground(Color.WHITE);
        this.mNodeSizePageRankSlider.setEnabled(false);
        final JRadioButton rank = new JRadioButton("PageRank with Prior");
        rank.setBackground(Color.WHITE);
        buttons.add(rank);
        jp.add(rank);
        jp.add(this.mNodeSizePageRankSlider);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == rank) {
                    RankingDemo.this.mNodeSizePageRankSlider.setEnabled(true);
                    RankingDemo.this.mNodeSizeDegreeSlider.setEnabled(false);
                }
                if (e.getSource() == degree) {
                    RankingDemo.this.mNodeSizePageRankSlider.setEnabled(false);
                    RankingDemo.this.mNodeSizeDegreeSlider.setEnabled(true);
                }
            }
        };
        degree.addActionListener(al);
        rank.addActionListener(al);
        return jp;
    }

    protected void displayGraph(Graph graph) {
        this.mCurrentGraph = graph;
        this.mVisualizer = new FRLayout(this.mCurrentGraph);
        this.mRenderer = new BasicRenderer();
        this.mRenderer.setLabel("LABEL");
        this.mRenderer.setSizeKey("jung.algorithms.importance.PageRank.RankScore");
        if (this.mVizViewer != null) {
            this.remove(this.mVizViewer);
        }
        this.mVizViewer = new VisualizationViewer(this.mVisualizer, (Renderer)this.mRenderer);
        this.mVizViewer.setBackground(Color.WHITE);
        this.add(this.mVizViewer);
        this.mVizViewer.revalidate();
        this.mVizViewer.repaint();
    }

    protected void recalculate(Graph graph, Vertex startingVertex, boolean fixAxes) {
        DegreeDistributionRanker degreeRanker = new DegreeDistributionRanker(graph, true);
        degreeRanker.setRemoveRankScoresOnFinalize(false);
        degreeRanker.evaluate();
        List rankingList = degreeRanker.getRankings();
        Ranking degreeMax = (Ranking)rankingList.get(0);
        Ranking degreeMin = (Ranking)rankingList.get(rankingList.size() - 1);
        HashSet<Vertex> priors = new HashSet<Vertex>();
        priors.add(startingVertex);
        PageRankWithPriors pageRank = new PageRankWithPriors((DirectedGraph)graph, 0.2, priors, null);
        pageRank.setRemoveRankScoresOnFinalize(false);
        pageRank.evaluate();
        rankingList = pageRank.getRankings();
        Ranking pageRankMax = (Ranking)rankingList.get(0);
        Ranking pageRankMin = (Ranking)rankingList.get(rankingList.size() - 1);
        BetweennessCentrality bc = new BetweennessCentrality(graph, true);
        bc.setRemoveRankScoresOnFinalize(false);
        bc.evaluate();
        rankingList = bc.getRankings();
        Ranking betwennessMax = (Ranking)rankingList.get(0);
        int minScaleRatio = (int)Math.floor(1.0 / pageRankMin.rankScore);
        int maxScaleRatio = (int)Math.floor(1.0 / pageRankMax.rankScore);
        if (fixAxes) {
            this.mNodeSizePageRankSlider.setMaximum(minScaleRatio * 30);
            this.mNodeSizePageRankSlider.setMinimum(maxScaleRatio * 10);
        }
        if (fixAxes) {
            this.mNodeAcceptBetweennessSlider.setMaximum((int)Math.ceil(betwennessMax.rankScore / 4.0));
            this.mNodeAcceptBetweennessSlider.setMinimum(1);
        }
        minScaleRatio = (int)Math.floor(1.0 / degreeMin.rankScore);
        maxScaleRatio = (int)Math.floor(1.0 / degreeMax.rankScore);
        if (fixAxes) {
            this.mNodeSizeDegreeSlider.setMaximum(minScaleRatio * 15);
            this.mNodeSizeDegreeSlider.setMinimum(maxScaleRatio * 5);
        }
        this.mVizViewer.revalidate();
        this.mVizViewer.repaint();
    }

    public static void main(String[] args) throws IOException, StringLabeller.UniqueLabelException {
        JFrame jf = new JFrame("Scott's Toy Network Viewer");
        PajekNetReader pnr = new PajekNetReader(true);
        Graph ug = pnr.load("samples/datasets/smyth.net", (Graph)new SparseGraph());
        DirectedGraph g = DirectionTransformer.toDirected(ug);
        GraphUtils.copyLabels(StringLabeller.getLabeller(ug, "jung.io.PajekNetReader.LABEL"), StringLabeller.getLabeller(g, "jung.io.PajekNetReader.LABEL"));
        RankingDemo vizApp = new RankingDemo(g);
        jf.getContentPane().add(vizApp);
        jf.setSize(700, 500);
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.setVisible(true);
    }

    public class MyJPanel
    extends JPanel {
        public MyJPanel(String title, Color color) {
            this.setLayout(new BoxLayout(this, 1));
            this.setBackground(Color.WHITE);
            Border redline = BorderFactory.createLineBorder(color);
            TitledBorder compound = BorderFactory.createTitledBorder(redline, title);
            this.setBorder(compound);
        }
    }
}

