/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.iterablelayouts;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import java.util.Iterator;
import java.util.Set;
import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.iter.GraphLayoutPanelUtils;
import samples.preview_new_graphdraw.iter.UpdatableIterableLayout;

public class SpringLayout
extends UpdatableIterableLayout {
    public static final int RANGE = 100;
    protected static final double FORCE_CONSTANT = 0.3333333333333333;
    public static final int STRETCH = 70;

    protected VisVertex createVisVertex(VisVertex ve) {
        return new SpringVertex(ve.getVertex(), ve.getX(), ve.getY());
    }

    protected VisEdge createVisEdge(Edge ve, VisVertex front, VisVertex back) {
        return new SpringEdge(ve, front, back);
    }

    public void initializeLocationsFromLayout(EmittedLayout el) {
        Iterator iter = el.visVertexMap.values().iterator();
        while (iter.hasNext()) {
            VisVertex vv = (VisVertex)iter.next();
            el.visVertexMap.put(vv.getVertex(), this.createVisVertex(vv));
        }
        iter = el.visEdgeMap.values().iterator();
        while (iter.hasNext()) {
            VisEdge ve = (VisEdge)iter.next();
            Edge e = ve.getEdge();
            Pair p = e.getEndpoints();
            VisVertex front = el.getVisVertex((Vertex)p.getFirst());
            VisVertex back = el.getVisVertex((Vertex)p.getSecond());
            el.visEdgeMap.put(e, this.createVisEdge(e, front, back));
        }
        this.currentLayout = el;
        this.returnableLayout = GraphLayoutPanelUtils.copy(this.currentLayout);
    }

    public void calculate() {
        Set vertices = this.currentLayout.visVertexMap.keySet();
        Set edges = this.currentLayout.visEdgeMap.keySet();
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            SpringVertex svd = (SpringVertex)this.getVisVertex(v);
            if (svd == null) {
                System.out.println("How confusing!");
                continue;
            }
            svd.dx /= 4.0;
            svd.dy /= 4.0;
            svd.edgedy = 0.0;
            svd.edgedx = 0.0;
            svd.repulsiondy = 0.0;
            svd.repulsiondx = 0.0;
        }
        this.relaxEdges(edges);
        this.calculateRepulsion(vertices);
        this.moveNodes(vertices);
    }

    protected Vertex getAVertex(Edge e) {
        Vertex v = (Vertex)e.getEndpoints().getFirst();
        return v;
    }

    protected void relaxEdges(Set edges) {
        Iterator i = edges.iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            Vertex v1 = this.getAVertex(e);
            Vertex v2 = e.getOpposite(v1);
            double vx = this.getVisVertex(v1).getX() - this.getVisVertex(v2).getX();
            double vy = this.getVisVertex(v1).getY() - this.getVisVertex(v2).getY();
            double len = Math.sqrt(vx * vx + vy * vy);
            double desiredLen = this.getLength(e);
            len = len == 0.0 ? 1.0E-4 : len;
            double f = 0.3333333333333333 * (desiredLen - len) / len;
            double dx = (f *= Math.pow(0.7, v1.degree() + v2.degree() - 2)) * vx;
            double dy = f * vy;
            SpringVertex v1D = (SpringVertex)this.getVisVertex(v1);
            SpringVertex v2D = (SpringVertex)this.getVisVertex(v2);
            SpringEdge sed = (SpringEdge)this.getVisEdge(e);
            sed.f = f;
            v1D.edgedx += dx;
            v1D.edgedy += dy;
            v2D.edgedx += -dx;
            v2D.edgedy += -dy;
        }
    }

    protected void calculateRepulsion(Set vertices) {
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            SpringVertex svd = (SpringVertex)this.getVisVertex(v);
            double dx = 0.0;
            double dy = 0.0;
            Iterator iter2 = vertices.iterator();
            while (iter2.hasNext()) {
                double vy;
                Vertex v2 = (Vertex)iter2.next();
                if (v == v2) continue;
                double vx = this.getVisVertex(v).getX() - this.getVisVertex(v2).getX();
                double distance = vx * vx + (vy = this.getVisVertex(v).getY() - this.getVisVertex(v2).getY()) * vy;
                if (distance == 0.0) {
                    dx += Math.random();
                    dy += Math.random();
                    continue;
                }
                if (!(distance < 10000.0)) continue;
                double factor = 1.0;
                dx += factor * vx / Math.pow(distance, 2.0);
                dy += factor * vy / Math.pow(distance, 2.0);
            }
            double dlen = dx * dx + dy * dy;
            if (!(dlen > 0.0)) continue;
            dlen = Math.sqrt(dlen) / 2.0;
            svd.repulsiondx += dx / dlen;
            svd.repulsiondy += dy / dlen;
        }
    }

    protected void moveNodes(Set vertices) {
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            Vertex v = (Vertex)i.next();
            SpringVertex vd = (SpringVertex)this.getVisVertex(v);
            vd.dx += vd.repulsiondx + vd.edgedx;
            vd.dy += vd.repulsiondy + vd.edgedy;
            double deltaChangeX = Math.max(-5.0, Math.min(5.0, vd.dx));
            double deltaChangeY = Math.max(-5.0, Math.min(5.0, vd.dy));
            vd.offset(deltaChangeX, deltaChangeY);
            int width = this.getScreenSize().width;
            int height = this.getScreenSize().height;
            if (vd.getX() < 0.0) {
                vd.setX(0.0);
            } else if (vd.getX() > (double)width) {
                vd.setX(width);
            }
            if (vd.getY() < 0.0) {
                vd.setY(0.0);
                continue;
            }
            if (!(vd.getY() > (double)height)) continue;
            vd.setY(height);
        }
    }

    public double getLength(Edge e) {
        return ((SpringEdge)this.getVisEdge((Edge)e)).length;
    }

    public boolean iterationsAreDone() {
        return false;
    }

    public boolean isFinite() {
        return false;
    }

    protected VisEdge addVisEdge(Edge e) {
        Pair p = e.getEndpoints();
        Vertex v1 = (Vertex)p.getFirst();
        Vertex v2 = (Vertex)p.getSecond();
        VisVertex vv1 = this.currentLayout.getVisVertex(v1);
        VisVertex vv2 = this.currentLayout.getVisVertex(v2);
        return this.createVisEdge(e, vv1, vv2);
    }

    protected VisVertex addVisVertex(Vertex v) {
        VisVertex vv = super.addVisVertex(v);
        return this.createVisVertex(vv);
    }

    protected static class SpringEdge
    extends VisEdge {
        public double f;
        double length;

        public SpringEdge(Edge e, VisVertex v1, VisVertex v2) {
            super(e, v1, v2);
        }
    }

    protected static class SpringVertex
    extends VisVertex {
        public double edgedx;
        public double edgedy;
        public double repulsiondx;
        public double repulsiondy;
        public double dx;
        public double dy;

        public SpringVertex(Vertex v, double x, double y) {
            super(v, x, y);
        }
    }
}

