/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.iterablelayouts;

import edu.uci.ics.jung.exceptions.FatalException;
import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.iter.IterableLayout;

public class WrappedIterableLayout
extends IterableLayout {
    protected IterableLayout next;
    protected IterableLayout start;
    protected final int frames;
    protected int thisFrame = 0;
    boolean currentlyInStart = true;

    public WrappedIterableLayout(IterableLayout start, IterableLayout next) {
        this.start = start;
        this.next = next;
        this.frames = -1;
        if (!start.isFinite()) {
            throw new IllegalArgumentException(start + " is not finite; you'll never see the next");
        }
    }

    public WrappedIterableLayout(IterableLayout start, IterableLayout next, int frames) {
        this.start = start;
        this.next = next;
        this.frames = frames;
        if (!start.isFinite()) {
            throw new IllegalArgumentException(start + " is not finite; you'll never see the next");
        }
    }

    public boolean iterationsAreDone() {
        if (this.frames > 0) {
            return this.thisFrame > this.frames;
        }
        return this.next.iterationsAreDone();
    }

    public boolean isFinite() {
        return this.frames > 0 || this.next.isFinite();
    }

    public void advance() {
        if (this.currentlyInStart) {
            if (!this.start.iterationsAreDone()) {
                this.start.advance();
            } else {
                EmittedLayout seedOfTheNext = this.start.emit();
                this.next.initializeLocationsFromLayout(seedOfTheNext);
                this.currentlyInStart = false;
            }
        } else {
            this.next.advance();
            ++this.thisFrame;
        }
    }

    public EmittedLayout emit() {
        EmittedLayout rv = this.currentlyInStart ? this.start.emit() : this.next.emit();
        if (rv == null) {
            throw new FatalException("Layouts should not generate null");
        }
        return rv;
    }

    public void initializeLocationsFromLayout(EmittedLayout inputLayout) {
        this.start.initializeLocationsFromLayout(inputLayout);
    }

    protected void calculate() {
        throw new FatalException("Calculate should not be called in a WrappedIterableLayout");
    }
}

