/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.test;

import edu.uci.ics.jung.graph.Edge;
import samples.preview_new_graphdraw.CoordinateUtil;
import samples.preview_new_graphdraw.Coordinates;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;

public class CircleEdge
extends VisEdge {
    public VisEdge copy(VisVertex front, VisVertex back) {
        return new CircleEdge(this.mEdge, front, back);
    }

    public CircleEdge(Edge ve, VisVertex front, VisVertex back) {
        super(ve, front, back);
    }

    public Coordinates getCenter() {
        return CoordinateUtil.midpoint(this.getFront(), this.getBack());
    }

    public double getRadius() {
        return CoordinateUtil.distance(this.getFront(), this.getBack()) / 2.0;
    }

    public double getStartAngle() {
        double theta = CoordinateUtil.angleBetween(this.getFront(), this.getBack().getX(), this.getBack().getY());
        return theta;
    }

    public double getSquareDistance(double x, double y) {
        double theta = CoordinateUtil.angleBetween(this.getCenter(), x, y);
        double theta_of_circle = this.getStartAngle();
        if (theta_of_circle > Math.PI) {
            theta_of_circle -= Math.PI * 2;
        }
        if (theta > Math.PI) {
            theta -= Math.PI * 2;
        }
        if (theta > theta_of_circle && theta < theta_of_circle + Math.PI) {
            double toCenter = CoordinateUtil.distance(this.getCenter(), x, y);
            double actual = Math.abs(toCenter - this.getRadius());
            return actual * actual;
        }
        System.out.println(this.getEdge() + " wrong half plane ");
        return Double.POSITIVE_INFINITY;
    }
}

