/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageSupport;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;

public class MemoryByteRasterImage
extends JimiRasterImageSupport
implements ByteRasterImage,
BitRasterImage {
    protected byte[] imageData;
    protected byte[] pixelBuffer = new byte[1];

    public MemoryByteRasterImage(int n, int n2, ColorModel colorModel) {
        super(n, n2, colorModel);
        try {
            this.initStorage();
        }
        catch (JimiException jimiException) {
            this.setError();
        }
    }

    public byte[] asByteArray() {
        return this.imageData;
    }

    protected ColorModel getAppropriateColorModel(ColorModel colorModel) {
        if (colorModel instanceof IndexColorModel) {
            return colorModel;
        }
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        byte[] byArray4 = new byte[256];
        int n = 0;
        while (n < 256) {
            int n2 = colorModel.getRGB(n);
            byArray4[n] = (byte)(n2 >>> 24);
            byArray[n] = (byte)(n2 >>> 16);
            byArray2[n] = (byte)(n2 >>> 8);
            byArray3[n] = (byte)n2;
            ++n;
        }
        colorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        return colorModel;
    }

    public byte getPixel(int n, int n2) throws ImageAccessException {
        try {
            return this.imageData[n + n2 * this.getWidth()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ImageAccessException(arrayIndexOutOfBoundsException.toString());
        }
    }

    public int getPixelRGB(int n, int n2) throws ImageAccessException {
        return this.getColorModel().getRGB(this.imageData[n + n2 * this.getWidth()] & 0xFF);
    }

    public void getRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        try {
            int n7 = 0;
            while (n7 < n4) {
                System.arraycopy(this.imageData, n + (n2 + n7) * this.getWidth(), byArray, n5 + n7 * n6, this.getWidth());
                ++n7;
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    public void getRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
    }

    public void getRectangleRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        ColorModel colorModel = this.getColorModel();
        try {
            int n7 = 0;
            while (n7 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    nArray[n5 + n8 + n7 * n6] = colorModel.getRGB(this.imageData[n + n8 + (n2 + n7) * this.getWidth()] & 0xFF);
                    ++n8;
                }
                ++n7;
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    public void getRow(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.getRectangle(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    public void getRowPacked(int n, byte[] byArray, int n2) throws ImageAccessException {
    }

    public void getRowRGB(int n, int[] nArray, int n2) throws ImageAccessException {
        this.getRectangleRGB(0, n, this.getWidth(), 1, nArray, n2, 0);
    }

    protected void initStorage() throws JimiException {
        this.imageData = new byte[this.getWidth() * this.getHeight()];
    }

    protected synchronized void sendPixel(int n, int n2, byte by) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        this.pixelBuffer[0] = by;
        multicastImageConsumer.setPixels(n, n2, 1, 1, this.getColorModel(), this.pixelBuffer, 0, 1);
    }

    protected void sendRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
        multicastImageConsumer.setPixels(n, n2, n3, n4, this.getColorModel(), byArray, n5, this.getWidth());
    }

    protected void sendRegionToConsumerFully(ImageConsumer imageConsumer, Rectangle rectangle) throws ImageAccessException {
        int n = rectangle.x + rectangle.y * this.getWidth();
        imageConsumer.setPixels(0, 0, rectangle.width, rectangle.height, this.getColorModel(), this.imageData, n, this.getWidth());
    }

    protected void sendRow(int n, byte[] byArray, int n2) {
        this.sendRectangle(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    protected void sendToConsumerFully(ImageConsumer imageConsumer) throws ImageAccessException {
        imageConsumer.setPixels(0, 0, this.getWidth(), this.getHeight(), this.getColorModel(), this.imageData, 0, this.getWidth());
    }

    public void setPixel(int n, int n2, byte by) throws ImageAccessException {
        this.setModified();
        this.sendPixel(n, n2, by);
        this.storePixel(n, n2, by);
    }

    public void setRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        this.sendRectangle(n, n2, n3, n4, byArray, n5, n6);
        this.storeRectangle(n, n2, n3, n4, byArray, n5, n6);
    }

    public void setRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        byte[] byArray2 = new byte[n3 * n4];
        int n7 = 0;
        while (n7 < n4) {
            JimiUtil.expandOneBitPixels(byArray, byArray2, n3, n6 * n7, n3 * n7);
            ++n7;
        }
        this.setRectangle(n, n2, n3, n4, byArray2, 0, n3);
    }

    public void setRow(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.setRectangle(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    public void setRowPacked(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.setRectanglePacked(0, n, this.getWidth(), 1, byArray, n2, this.getWidth());
    }

    public void storePixel(int n, int n2, byte by) throws ImageAccessException {
        try {
            this.imageData[n + n2 * this.getWidth()] = by;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ImageAccessException(arrayIndexOutOfBoundsException.toString());
        }
    }

    public void storeRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        try {
            int n7 = 0;
            while (n7 < n4) {
                System.arraycopy(byArray, n5 + n7 * n6, this.imageData, n + (n2 + n7) * this.getWidth(), n3);
                ++n7;
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    public void storeRow(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.storeRectangle(0, n, this.getWidth(), 1, byArray, n2, 0);
    }
}

