/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JNIWrapper;
import com.franz.jlinker.JavaLinkDist;
import com.franz.jlinker.LispCall;
import com.franz.jlinker.LispCallImplementation;
import java.lang.reflect.Field;

public class LispCallJNI
extends LispCallImplementation {
    static Class opclass = null;
    LispCall lci;
    String argtypes = "";
    int rescount = -1;
    public String restypes = null;
    public Object res0 = null;
    public Object res1 = null;
    public Object res2 = null;
    public Object res3 = null;
    public Object res4 = null;
    public int int0 = 0;
    public float float0 = 0.0f;
    public double double0 = 0.0;
    static Object[] eventQueue;
    static int eventCount;
    static Thread lispThread;
    static int callFlag;

    Class getOpClass() {
        return opclass;
    }

    LispCallImplementation builder(LispCall lispCall, int n, boolean bl, String string) {
        LispCallJNI lispCallJNI = new LispCallJNI();
        lispCallJNI.lci = lispCall;
        if (!string.equals("")) {
            lispCall.lispOp = string;
        }
        return lispCallJNI;
    }

    void setOp(String string) {
        this.setOp((Object)string);
    }

    void setOp(Object object) {
        this.lci.lispOp = object;
        if (this.lci.state == 0) {
            this.lci.state = 1;
        }
    }

    synchronized int addArgWrapped(String string, Object object) {
        if (this.lci.state != 1) {
            throw new IllegalArgumentException("Wrong state");
        }
        int n = this.lci.newHolder(object);
        this.argtypes = n == 1 ? string : this.argtypes + string;
        return n;
    }

    synchronized int addArg(int n) {
        return this.addArgWrapped("I", new Integer(n));
    }

    synchronized int addArg(short s) {
        return this.addArgWrapped("S", new Integer(s));
    }

    synchronized int addArg(byte by) {
        return this.addArgWrapped("B", new Integer(by));
    }

    synchronized int addArg(long l) {
        return this.addArgWrapped("J", new Long(l));
    }

    synchronized int addArg(boolean bl) {
        int n = 0;
        if (bl) {
            n = 1;
        }
        return this.addArgWrapped("Z", new Integer(n));
    }

    synchronized int addArg(int[] nArray) {
        return this.addArgWrapped("N", nArray);
    }

    synchronized int addArg(short[] sArray) {
        return this.addArgWrapped("M", sArray);
    }

    synchronized int addArg(byte[] byArray) {
        return this.addArgWrapped("K", byArray);
    }

    synchronized int addArg(String string) {
        return this.addArgWrapped("T", string);
    }

    synchronized int addArg(String[] stringArray) {
        return this.addArgWrapped("U", stringArray);
    }

    synchronized int addArg(double d) {
        return this.addArgWrapped("D", new Double(d));
    }

    synchronized int addArg(float f) {
        return this.addArgWrapped("F", new Float(f));
    }

    synchronized int addArg(double[] dArray) {
        return this.addArgWrapped("E", dArray);
    }

    synchronized int addArg(float[] fArray) {
        return this.addArgWrapped("G", fArray);
    }

    synchronized int addArg(Object object) {
        return this.addArgWrapped("X", object);
    }

    synchronized int addSymbol(String string) {
        return this.addArgWrapped("Y", new JNIWrapper(string, "", 0));
    }

    synchronized int addSymbol(String string, String string2) {
        return this.addArgWrapped("Y", new JNIWrapper(string, string2, 0));
    }

    synchronized int addSymbol(String string, String string2, int n) {
        return this.addArgWrapped("Y", new JNIWrapper(string, string2, n));
    }

    synchronized void assemble(String string) {
        Object[] objectArray;
        if (this.lci.state != 1) {
            this.lci.throwWrongState(string, "");
        }
        this.lci.args = objectArray = new Object[this.lci.count];
        for (int i = 0; i < this.lci.count; ++i) {
            objectArray[this.lci.count - i - 1] = this.lci.chain.arg;
            this.lci.chain = this.lci.chain.next;
        }
        this.lci.count = 0;
        this.lci.state = 2;
    }

    native int callInLisp(int var1, Object var2, int var3, String var4, Object[] var5);

    native int nthIntValue(int var1, JNIWrapper var2);

    native Object nthObjectValue(int var1, JNIWrapper var2);

    static synchronized int callLispWithEvent(String string, int n, String[] stringArray, int[] nArray) {
        if (callFlag == 2) {
            return LispCallJNI.callLispHandler(string, n, stringArray, nArray);
        }
        eventQueue = new Object[]{string, new Integer(n), stringArray, nArray, eventQueue};
        ++eventCount;
        return 0;
    }

    public static synchronized int pollEventQueue(int n) {
        if (eventQueue == null) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = eventQueue;
            eventQueue = (Object[])eventQueue[4];
            --eventCount;
            --n2;
            LispCallJNI.callLispHandler((String)objectArray[0], (Integer)objectArray[1], (String[])objectArray[2], (int[])objectArray[3]);
            if (eventQueue != null) continue;
            return n2;
        }
        return eventCount;
    }

    static native int callLispHandler(String var0, int var1, String[] var2, int[] var3);

    int setLispError(String string) {
        this.rescount = -1;
        this.res0 = null;
        this.restypes = "R";
        this.res1 = string;
        return 0;
    }

    synchronized int call() throws JavaLinkDist.JLinkerException {
        if (this.lci.state == 1) {
            this.assemble("call");
        }
        if (this.lci.state != 2) {
            this.lci.throwWrongState("call", "");
        }
        this.rescount = this.callInLisp(this.lci.callStyle, this.lci.lispOp, this.lci.lispOpKind, this.argtypes, (Object[])this.lci.args);
        if (this.rescount < 0) {
            throw new JavaLinkDist.JLinkerException("Lisp error " + this.res1.toString());
        }
        if (!this.lci.retain) {
            this.lci.args = null;
        }
        if (this.lci.callStyle >= 3) {
            this.lci.waitref = this.res0;
            this.lci.state = 4;
            return 0;
        }
        this.lci.waitref = null;
        this.lci.state = 3;
        this.lci.res = this.lci;
        return this.rescount;
    }

    synchronized Object getValue(int n) {
        Object object = null;
        if (n < this.rescount) {
            String string = this.restypes.substring(n, n + 1);
            if (string.equals("V")) {
                this.lci.throwWrongState("getValue", " when value already retrieved once");
            } else {
                object = string.equals("W") ? null : (string.equals("Z") ? new Boolean(this.int0 == 1) : (string.equals("C") ? new Character((char)this.int0) : (string.equals("B") ? new Byte((byte)this.int0) : (string.equals("S") ? new Short((short)this.int0) : (string.equals("I") ? new Integer(this.int0) : (string.equals("F") ? new Float(this.float0) : (string.equals("D") ? new Double(this.double0) : (n == 0 ? this.res0 : (n == 1 ? this.res1 : (n == 2 ? this.res2 : (n == 3 ? this.res3 : (this.rescount == 5 ? this.res4 : this.nthObjectValue(n - 4, (JNIWrapper)this.res4)))))))))))));
            }
            if (!this.lci.retain) {
                switch (n) {
                    case 0: {
                        this.res0 = null;
                    }
                    case 1: {
                        this.res1 = null;
                    }
                    case 2: {
                        this.res2 = null;
                    }
                    case 3: {
                        this.res3 = null;
                    }
                    case 4: {
                        if (this.rescount != 5) break;
                        this.res4 = null;
                    }
                }
                this.restypes = this.restypes.substring(0, n) + "V" + this.restypes.substring(n + 1);
            }
        } else {
            this.lci.throwWrongState("getValue", " when index is out of range.");
        }
        return object;
    }

    int typeOf(Object object) {
        JNIWrapper jNIWrapper = (JNIWrapper)object;
        String string = jNIWrapper.type;
        return this.translateType(string);
    }

    int translateType(String string) {
        return JNIWrapper.translateType(string);
    }

    String getType(int n) {
        if (n < this.restypes.length()) {
            String string = this.restypes.substring(n, n + 1);
            try {
                if (string.equals("A")) {
                    string = ((JNIWrapper)this.getValue((int)n)).type;
                }
            }
            catch (ClassCastException classCastException) {
                Object object = this.getValue(n);
                throw new ClassCastException("Casting " + object.getClass().getName() + " to JNIWrapper");
            }
            return string;
        }
        return "H";
    }

    synchronized int typeOf(int n) {
        return this.translateType(this.getType(n));
    }

    synchronized int intValue(int n) {
        String string = this.getType(n);
        if (n == 0) {
            if (string.equals("I") || string.equals("S") || string.equals("B")) {
                return this.int0;
            }
        } else {
            if (string.equals("I")) {
                return (Integer)this.getValue(n);
            }
            if (string.equals("S")) {
                return ((Short)this.getValue(n)).shortValue();
            }
            if (string.equals("B")) {
                return ((Byte)this.getValue(n)).byteValue();
            }
        }
        throw new UnsupportedOperationException("intValue of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized long longValue(int n) {
        String string = this.getType(n);
        if (n == 0) {
            if (string.equals("I") || string.equals("S") || string.equals("B")) {
                return this.int0;
            }
            if (string.equals("J")) {
                return (Long)this.res0;
            }
        } else {
            if (string.equals("J")) {
                return (Long)this.getValue(n);
            }
            if (string.equals("I")) {
                return ((Integer)this.getValue(n)).intValue();
            }
            if (string.equals("S")) {
                return ((Short)this.getValue(n)).shortValue();
            }
            if (string.equals("B")) {
                return ((Byte)this.getValue(n)).byteValue();
            }
        }
        throw new UnsupportedOperationException("longValue of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized double doubleValue(int n) {
        String string = this.getType(n);
        if (n == 0) {
            if (string.equals("D")) {
                return this.double0;
            }
            if (string.equals("F")) {
                return this.float0;
            }
        } else {
            if (string.equals("D")) {
                return (Double)this.getValue(n);
            }
            if (string.equals("F")) {
                return ((Float)this.getValue(n)).floatValue();
            }
        }
        throw new UnsupportedOperationException("doubleValue of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized float floatValue(int n) {
        String string = this.getType(n);
        if (n == 0) {
            if (string.equals("D")) {
                return (float)this.double0;
            }
            if (string.equals("F")) {
                return this.float0;
            }
        } else {
            if (string.equals("D")) {
                return (float)((Double)this.getValue(n)).doubleValue();
            }
            if (string.equals("F")) {
                return ((Float)this.getValue(n)).floatValue();
            }
        }
        throw new UnsupportedOperationException("floatValue of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized boolean booleanValue(int n) {
        String string = this.getType(n);
        if (n == 0) {
            if (string.equals("Z")) {
                return 1 == this.int0;
            }
        } else if (string.equals("Z")) {
            return (Boolean)this.getValue(n);
        }
        throw new UnsupportedOperationException("booleanValue of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized String stringValue(int n) {
        String string = this.getType(n);
        if (string.equals("T")) {
            return (String)this.getValue(n);
        }
        throw new UnsupportedOperationException("stringValue of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized int[] intArrayValue(int n) {
        String string = this.getType(n);
        if (string.equals("N")) {
            return (int[])this.getValue(n);
        }
        throw new UnsupportedOperationException("intArrayValue of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized String[] stringArrayValue(int n) {
        String string = this.getType(n);
        if (string.equals("U")) {
            return (String[])this.getValue(n);
        }
        throw new UnsupportedOperationException("stringArrayValue of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized double[] doubleArrayValue(int n) {
        String string = this.getType(n);
        if (string.equals("E")) {
            return (double[])this.getValue(n);
        }
        throw new UnsupportedOperationException("doubleArrayValue of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized float[] floatArrayValue(int n) {
        String string = this.getType(n);
        if (string.equals("G")) {
            return (float[])this.getValue(n);
        }
        throw new UnsupportedOperationException("floatArrayValue of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized Object objectValue(int n) {
        return this.getValue(n);
    }

    synchronized String symbolName(int n) {
        String string = this.getType(n);
        if (string.equals("Y")) {
            return (String)((JNIWrapper)this.getValue((int)n)).data;
        }
        throw new UnsupportedOperationException("symbolName of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized String symbolPackage(int n) {
        String string = this.getType(n);
        if (string.equals("Y")) {
            return ((JNIWrapper)this.getValue((int)n)).packageName;
        }
        throw new UnsupportedOperationException("symbolPackage of " + LispCall.nameOfType(this.translateType(string)));
    }

    synchronized String lispType(int n) {
        String string = this.getType(n);
        if (string.equals("P")) {
            return ((JNIWrapper)this.getValue(n)).getLispType();
        }
        if (string.equals("Y")) {
            return ((JNIWrapper)this.getValue(n)).getLispType();
        }
        return LispCall.nameOfType(this.typeOf(n));
    }

    synchronized int query(boolean bl, boolean bl2) throws JavaLinkDist.JLinkerException {
        switch (this.lci.state) {
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                return -100;
            }
            case 3: {
                if (this.rescount == -1) {
                    return -99;
                }
                return this.rescount;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                return -100;
            }
        }
        if (this.lci.waitref == null) {
            return -100;
        }
        if (bl && this.lci.state == 4) {
            int n = this.nthIntValue(0, (JNIWrapper)this.lci.waitref);
            if (n >= 0) {
                this.lci.waitres = n;
                this.lci.state = 5;
            } else if (n == -98) {
                this.lci.waitres = n;
                this.lci.state = 5;
            } else if (n == -99) {
                this.lci.state = 3;
                this.lci.res = this.lci;
                return -99;
            }
        }
        if (bl2 && this.lci.state == 5) {
            this.rescount = this.callInLisp(2, "javatools.jlinker::jl-async-results", 0, "P", new Object[]{this.lci.waitref});
            this.lci.state = 3;
            this.lci.res = this.lci;
            if (this.rescount == -1) {
                return 0;
            }
            return this.rescount;
        }
        if (this.lci.state == 5) {
            if (bl) {
                return this.lci.waitres;
            }
            return -11;
        }
        return -10;
    }

    synchronized void close() {
    }

    synchronized void reset() {
        this.rescount = -1;
    }

    synchronized void setArgWrapped(int n, String string, Object object) {
        switch (this.lci.state) {
            case 1: {
                this.assemble("setArg");
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.lci.throwWrongState("setArg", "");
            }
        }
        this.argtypes = this.argtypes.substring(0, n) + string + this.argtypes.substring(n + 1);
        Object[] objectArray = (Object[])this.lci.args;
        objectArray[n] = object;
    }

    synchronized void setArg(int n, boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.setArgWrapped(n, "Z", new Integer(n2));
    }

    synchronized void setArg(int n, int n2) {
        this.setArgWrapped(n, "I", new Integer(n2));
    }

    synchronized void setArg(int n, long l) {
        this.setArgWrapped(n, "J", new Long(l));
    }

    synchronized void setArg(int n, double d) {
        this.setArgWrapped(n, "D", new Double(d));
    }

    synchronized void setArg(int n, String string) {
        this.setArgWrapped(n, "T", string);
    }

    synchronized void setArg(int n, Object object) {
        this.setArgWrapped(n, "P", object);
    }

    synchronized void setArg(int n, int[] nArray) {
        this.setArgWrapped(n, "N", nArray);
    }

    synchronized void setArg(int n, double[] dArray) {
        this.setArgWrapped(n, "E", dArray);
    }

    synchronized void setArg(int n, String[] stringArray) {
        this.setArgWrapped(n, "U", stringArray);
    }

    synchronized void setSymbol(int n, String string) {
        this.setArgWrapped(n, "Y", new JNIWrapper(string, "", 0));
    }

    synchronized void setSymbol(int n, String string, String string2) {
        this.setArgWrapped(n, "Y", new JNIWrapper(string, string2, 0));
    }

    synchronized void setSymbol(int n, String string, String string2, int n2) {
        this.setArgWrapped(n, "Y", new JNIWrapper(string, string2, n2));
    }

    int mayCall() {
        switch (callFlag) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        if (lispThread.equals(Thread.currentThread())) {
            return 1;
        }
        return -1;
    }

    public static void setLispThread(int n) {
        if (n == 2) {
            callFlag = 2;
        } else {
            lispThread = Thread.currentThread();
            callFlag = 1;
        }
    }

    public static byte[] getLongFieldBytes(Field field, Object object) throws IllegalArgumentException, IllegalAccessException {
        byte[] byArray = new byte[9];
        long l = field.getLong(object);
        byArray[0] = 1;
        if (l < 0L) {
            byArray[0] = -1;
            l = -(l + 1L);
        }
        for (int i = 8; i > 0; --i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return byArray;
    }

    public static byte[] getLongValueBytes(Long l) throws IllegalArgumentException, IllegalAccessException {
        byte[] byArray = new byte[9];
        long l2 = l;
        byArray[0] = 1;
        if (l2 < 0L) {
            byArray[0] = -1;
            l2 = -(l2 + 1L);
        }
        for (int i = 8; i > 0; --i) {
            byArray[i] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        return byArray;
    }

    public static void setLongFieldBytes(Field field, Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws IllegalArgumentException, IllegalAccessException {
        long l = (long)(n2 & 0xFF) | (long)(n3 & 0xFF) << 8 | (long)(n4 & 0xFF) << 16 | (long)(n5 & 0xFF) << 24 | (long)(n6 & 0xFF) << 32 | (long)(n7 & 0xFF) << 40 | (long)(n8 & 0xFF) << 48 | (long)(n9 & 0xFF) << 56;
        if (n < 0) {
            l = -l - 1L;
        }
        field.setLong(object, l);
    }

    static {
        try {
            opclass = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        eventQueue = null;
        eventCount = 0;
        callFlag = 0;
    }
}

