/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.jpg;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.jpg.CompressInfo;
import com.sun.jimi.core.encoder.jpg.Shared;

public class ConvertColor {
    protected Shared shared;
    short[][] pixel_row;
    int[] jiIntBuf_;
    byte[] jiBufByt;
    static final short CS_UNKNOWN = 0;
    static final short CS_GRAYSCALE = 1;
    static final short CS_RGB = 2;
    static final short CS_YCbCr = 3;
    static final short SCALEBITS = 16;
    static final int ONE_HALF = 32768;
    static final short MAXJSAMPLE = 256;
    int[] rgb_ycc_tab;
    static final int R_Y_OFF = 0;
    static final int G_Y_OFF = 256;
    static final int B_Y_OFF = 512;
    static final int R_CB_OFF = 768;
    static final int G_CB_OFF = 1024;
    static final int B_CB_OFF = 1280;
    static final int R_CR_OFF = 1280;
    static final int G_CR_OFF = 1536;
    static final int B_CR_OFF = 1792;
    static final int TABLE_SIZE = 2048;
    int row_idx_;

    public ConvertColor(Shared shared) {
        this.shared = shared;
    }

    void Patching_get_gray_row(CompressInfo compressInfo, short[] sArray) throws JimiException {
        if (this.jiBufByt == null) {
            this.jiBufByt = new byte[compressInfo.image_width];
        }
        compressInfo.ji.getChannel(0, this.row_idx_, this.jiBufByt, 0);
        ++this.row_idx_;
        int n = 0;
        while (n < compressInfo.image_width) {
            sArray[n] = this.jiBufByt[n];
            ++n;
        }
    }

    public void get_grayscale_rows(CompressInfo compressInfo, int n, short[][][] sArray) throws JimiException {
        int n2 = 0;
        while (n2 < n) {
            this.Patching_get_gray_row(compressInfo, this.pixel_row[0]);
            int n3 = 0;
            while (n3 < compressInfo.image_width) {
                sArray[0][n2][n3] = this.pixel_row[0][n3];
                ++n3;
            }
            ++n2;
        }
    }

    public void get_rgb_ycc_rows(CompressInfo compressInfo, int n, short[][][] sArray) throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = compressInfo.ji;
        int n2 = this.row_idx_ + n;
        int n3 = compressInfo.image_width;
        int[] nArray = this.jiIntBuf_;
        int[] nArray2 = this.rgb_ycc_tab;
        int n4 = this.row_idx_;
        int n5 = 0;
        while (n5 < n) {
            adaptiveRasterImage.getChannel(n4, nArray, 0);
            int n6 = 0;
            while (n6 < n3) {
                int n7 = nArray[n6];
                int n8 = n7 >> 16 & 0xFF;
                int n9 = n7 >> 8 & 0xFF;
                int n10 = n7 & 0xFF;
                sArray[0][n5][n6] = (short)(nArray2[n8] + nArray2[n9 + 256] + nArray2[n10 + 512] >> 16);
                sArray[1][n5][n6] = (short)(nArray2[n8 + 768] + nArray2[n9 + 1024] + nArray2[n10 + 1280] >> 16);
                sArray[2][n5][n6] = (short)(nArray2[n8 + 1280] + nArray2[n9 + 1536] + nArray2[n10 + 1792] >> 16);
                ++n6;
            }
            ++n4;
            ++n5;
        }
        this.row_idx_ += n;
    }

    public void rgb_ycc_init(CompressInfo compressInfo) {
        this.pixel_row = new short[compressInfo.input_components][compressInfo.image_width];
        this.rgb_ycc_tab = new int[2048];
        int n = 0;
        while (n < 256) {
            this.rgb_ycc_tab[n] = ConvertColor.scaleToInt(0.299) * n;
            this.rgb_ycc_tab[n + 256] = ConvertColor.scaleToInt(0.587) * n;
            this.rgb_ycc_tab[n + 512] = ConvertColor.scaleToInt(0.114) * n + 32768;
            this.rgb_ycc_tab[n + 768] = -ConvertColor.scaleToInt(0.16874) * n;
            this.rgb_ycc_tab[n + 1024] = -ConvertColor.scaleToInt(0.33126) * n;
            this.rgb_ycc_tab[n + 1280] = ConvertColor.scaleToInt(0.5) * n + 0x800000;
            this.rgb_ycc_tab[n + 1536] = -ConvertColor.scaleToInt(0.41869) * n;
            this.rgb_ycc_tab[n + 1792] = -ConvertColor.scaleToInt(0.08131) * n;
            ++n;
        }
        this.row_idx_ = 0;
        this.jiIntBuf_ = new int[compressInfo.image_width];
    }

    public static int scaleToInt(double d) {
        return (int)(d * 65536.5);
    }
}

