/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.TranStruct;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;

public class Transport {
    public static final int ONE_WAY_CODE = 15;
    public static final int MESSAGE_CODE = 17;
    public static final int RESPONSE_CODE = 33;
    public static final int REQUEST_CODE = 18;
    public static final int REPLY_CODE = 34;
    public static final int ERROR_CODE = 62;
    public static final int DISCONNECT_CODE = 63;
    public static final int INVOKE_CODE = 19;
    public static final int ARGLIST_CODE = 20;
    public static final int RESULT_CODE = 35;
    public static final int ANSWER_CODE = 36;
    public static final int STRING_CODE = 66;
    public static final int INT_CODE = 65;
    public static final int SEQINT_CODE = 99;
    public static final int SEQSTRING_CODE = 101;
    public static final int SEQREAL_CODE = 103;
    public static final int EMPTY_SEQI_CODE = 98;
    public static final int EMPTY_SEQS_CODE = 100;
    public static final int EMPTY_SEQR_CODE = 102;
    public static final int EMPTY_SEQB_CODE = 104;
    public static final int SEQBYTE_CODE = 105;
    public static final int EMPTY_SEQK_CODE = 106;
    public static final int SEQSHORT_CODE = 107;
    public static final int EMPTY_SEQF_CODE = 110;
    public static final int SEQFLOAT_CODE = 111;
    public static final int NULL_CODE = 96;
    public static final int DEFAULT_BUFFER_SIZE = 512;
    public static final int SEQ_LENGTH_LIMIT = 0x1000000;
    public static final int PORT_IDLE = 0;
    public static final int PORT_CLOSED = -1;
    public static final int PORT_REQUEST = 3;
    public static final int PORT_WAITING_RESPONSE = 2;
    public static final int PORT_WAITING_REPLY = 4;
    public static final int PORT_MESSAGE = 1;
    public static final int PORT_INVOKE = 5;
    public static final int PORT_WAITING_RESULT = 6;
    public static final int TM_EXTNMASK = 57344;
    public static final int TM_EXBYTES = 8192;
    public static final int TM_EXSHORTS = 16384;
    public static final int TM_EXFLOATS = 24576;
    public static final String lispHomeName = "Lisp";
    public static int varInt = 0;
    public static int exData = 0;
    String kind;
    int state = -1;
    int oneWay = 0;
    public static final int ERR_PORT_CLASS = -101;
    public static final int ERR_PORT_STATE = -102;
    public static final int ERR_CALLBACK = -103;
    public static final int ERR_PROTOCOL = -104;
    public static final int ERR_REQUEST = -105;
    public static final int ERR_VAL_TYPE = -106;
    public static final int ERR_TOO_LONG = -107;
    public static final int ERR_PORT_IO = -108;
    public static final int ERR_FLUSH_IO = -108;
    public static final int ERR_THROW = -109;
    public static final int ERR_RESPONSE = -110;
    public static final int ERR_BUSY = -111;
    Socket socket;
    InputStream inStream;
    OutputStream outStream;
    byte[] buffer = new byte[512];
    int endpos = 0;
    Object[] iData;
    Thread softLock = null;
    static int debugClient = 0;
    static int debugServer = 0;
    public static final Class thisClass = new Transport().getClass();
    public static final String thisName = thisClass.getName();
    static boolean makeFlag = false;
    static boolean connectFlag = false;
    int haveCode = 1000000;

    public static String debug(int n, int n2) {
        int n3 = debugClient;
        if (n >= 0) {
            debugClient = n;
        }
        int n4 = debugServer;
        if (n2 >= 0) {
            debugServer = n2;
        }
        return "Client was " + n3 + " now " + debugClient + "  Server was " + n4 + " now " + debugServer;
    }

    boolean debugP(int n) {
        if (this.kind.equals("server") && n <= debugServer) {
            return true;
        }
        return this.kind.equals("client") && n <= debugClient;
    }

    public static boolean isP(Object object) {
        if (object == null) {
            return false;
        }
        return object.getClass().getName().equals(thisName);
    }

    public static Transport coerce(Object object) {
        try {
            return (Transport)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isInt(Object object) {
        return object.getClass().getName().equals("java.lang.Integer");
    }

    public static int getInt(Object object) {
        if (Transport.isInt(object)) {
            try {
                return (Integer)object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static boolean isString(Object object) {
        return object.getClass().getName().equals("java.lang.String");
    }

    public static String getString(Object object) {
        if (Transport.isString(object)) {
            try {
                return (String)object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static boolean isSeqInt(Object object) {
        return object.getClass().getName().equals("[I");
    }

    public static int[] getSeqInt(Object object) {
        if (Transport.isSeqInt(object)) {
            try {
                return (int[])object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new int[0];
    }

    public static boolean isSeqString(Object object) {
        return object.getClass().getName().equals("[Ljava.lang.String;");
    }

    public static String[] getSeqString(Object object) {
        if (Transport.isSeqString(object)) {
            try {
                return (String[])object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new String[0];
    }

    public static boolean isSeqReal(Object object) {
        return object.getClass().getName().equals("[D");
    }

    public static double[] getSeqReal(Object object) {
        if (Transport.isSeqReal(object)) {
            try {
                return (double[])object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new double[0];
    }

    Transport() {
    }

    Transport(String string, Socket socket) throws IOException {
        this.kind = string.equals("server") ? string : "client";
        this.socket = socket;
        this.inStream = socket.getInputStream();
        this.outStream = socket.getOutputStream();
        this.state = 0;
        this.softLock = null;
    }

    public static Object makeServerDataPort(String string, int n) {
        return Transport.makeServerDataPort(string, "", n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object makeServerDataPort(String string, String string2, int n) {
        try {
            Object object;
            Object object2;
            block41: {
                Exception exception2222;
                ServerSocket serverSocket;
                OutputStreamWriter outputStreamWriter;
                Serializable serializable;
                block37: {
                    serializable = thisClass;
                    synchronized (serializable) {
                        block36: {
                            if (!makeFlag) break block36;
                            String string3 = "makeServerDataPort is busy, try again later";
                            return string3;
                        }
                        makeFlag = true;
                    }
                    serializable = null;
                    outputStreamWriter = null;
                    serverSocket = null;
                    object2 = null;
                    if (string.equals("") && n == 0) {
                        String string4 = "Port number is required if advertising file is suppressed.";
                        return string4;
                    }
                    serverSocket = new ServerSocket(n);
                    n = serverSocket.getLocalPort();
                    if (!string.equals("")) {
                        serializable = new File(string);
                        outputStreamWriter = new FileWriter((File)serializable);
                        if (string2.equals("")) {
                            string2 = "localhost";
                        }
                        object = string2 + " " + String.valueOf(n) + "\n";
                        outputStreamWriter.write((String)object, 0, ((String)object).length());
                        outputStreamWriter.close();
                        outputStreamWriter = null;
                    }
                    object = serverSocket.accept();
                    ((Socket)object).setTcpNoDelay(true);
                    object2 = new Transport("server", (Socket)object);
                    Object var9_12 = null;
                    if (outputStreamWriter == null) break block37;
                    try {
                        outputStreamWriter.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                if (serializable != null) {
                    try {
                        ((File)serializable).delete();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception2222) {}
                }
                break block41;
                {
                    catch (Exception exception3) {
                        Exception exception42222;
                        object2 = exception3;
                        Object var9_13 = null;
                        if (outputStreamWriter != null) {
                            try {
                                outputStreamWriter.close();
                            }
                            catch (Exception exception42222) {
                                // empty catch block
                            }
                        }
                        if (serializable != null) {
                            try {
                                ((File)serializable).delete();
                            }
                            catch (Exception exception42222) {
                                // empty catch block
                            }
                        }
                        if (serverSocket != null) {
                            try {
                                serverSocket.close();
                            }
                            catch (Exception exception42222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    Exception exception52222;
                    Object var9_14 = null;
                    if (outputStreamWriter != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (Exception exception52222) {
                            // empty catch block
                        }
                    }
                    if (serializable != null) {
                        try {
                            ((File)serializable).delete();
                        }
                        catch (Exception exception52222) {
                            // empty catch block
                        }
                    }
                    if (serverSocket != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (Exception exception52222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            object = object2;
            return object;
        }
        finally {
            makeFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] makeServerDataPort(int n) {
        ServerSocket serverSocket = null;
        Object[] objectArray = new Object[2];
        try {
            Object[] objectArray2 = thisClass;
            synchronized (thisClass) {
                block10: {
                    if (!makeFlag) break block10;
                    objectArray[0] = new Integer(-111);
                    objectArray[1] = "makeServerDataPort is busy, try again later";
                    Object[] objectArray3 = objectArray;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return objectArray3;
                }
                makeFlag = true;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                try {
                    serverSocket = new ServerSocket(n);
                    objectArray[0] = new Integer(serverSocket.getLocalPort());
                    objectArray[1] = serverSocket;
                }
                catch (Exception exception) {
                    objectArray[0] = new Integer(0);
                    objectArray[1] = exception;
                }
                objectArray2 = objectArray;
                return objectArray2;
            }
        }
        finally {
            makeFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static Object makeServerDataPort(Object[] var0) {
        try {
            block20: {
                var1_1 = Transport.thisClass;
                synchronized (var1_1) {
                    block19: {
                        if (!Transport.makeFlag) break block19;
                        var2_2 = "makeServerDataPort is busy, try again later";
                        return var2_2;
                    }
                    Transport.makeFlag = true;
                }
                var1_1 = null;
                var2_3 = null;
                try {
                    var1_1 = (ServerSocket)var0[1];
                    var3_5 = var1_1.accept();
                    var3_5.setTcpNoDelay(true);
                    var2_3 = new Transport("server", (Socket)var3_5);
                    var5_7 = null;
                    ** if (var1_1 == null) goto lbl-1000
                }
                catch (Throwable var4_13) {
                    var5_9 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                        }
                        catch (Exception var6_12) {
                            // empty catch block
                        }
                    }
                    throw var4_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var1_1.close();
                    }
                    catch (Exception var6_10) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block20;
                    catch (Exception var3_6) {
                        var2_3 = var3_6;
                        var5_8 = null;
                        if (var1_1 != null) {
                            try {
                                var1_1.close();
                            }
                            catch (Exception var6_11) {}
                        }
                    }
                }
            }
            var3_5 = var2_3;
            return var3_5;
        }
        finally {
            Transport.makeFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object makeServerDataPort(int n, String string) {
        try {
            Object object = thisClass;
            synchronized (object) {
                block11: {
                    if (!makeFlag) break block11;
                    String string2 = "makeServerDataPort is busy, try again later";
                    return string2;
                }
                makeFlag = true;
            }
            object = null;
            try {
                Socket socket = new Socket(string, n);
                socket.setTcpNoDelay(true);
                object = new Transport("server", socket);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                makeFlag = false;
                return exception2;
            }
            Object object2 = object;
            return object2;
        }
        finally {
            makeFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object connectToServer(String var0) {
        var1_1 /* !! */  = Transport.thisClass;
        synchronized (var1_1 /* !! */ ) {
            if (Transport.connectFlag) {
                var2_2 = "connectToServer is busy, try again later";
                return var2_2;
            }
            Transport.connectFlag = true;
        }
        var2_3 = null;
        var3_4 = null;
        try {
            try {
                var1_1 /* !! */  = new File(var0);
                var2_3 = new FileReader((File)var1_1 /* !! */ );
                var5_5 /* !! */  = new char[100];
                var6_7 = 0;
                var7_9 = 0;
                var6_7 = var2_3.read(var5_5 /* !! */ , 0, 100);
                var2_3.close();
                var8_10 = new String(var5_5 /* !! */ , 0, var6_7);
                var9_11 = var8_10.indexOf(" ", 0);
                if (var9_11 < 1) {
                    throw new IOException("Ill-formed file");
                }
                var10_12 = var8_10.substring(0, var9_11);
                while (var8_10.startsWith(" ", var9_11)) {
                    ++var9_11;
                }
                var7_9 = Integer.parseInt(var8_10.substring(var9_11, var6_7).trim());
                var4_13 = new Socket(var10_12, var7_9);
                var4_13.setTcpNoDelay(true);
                var3_4 = new Transport("client", var4_13);
            }
            catch (Exception var5_6) {
                var6_8 = var5_6;
                var12_15 = null;
                if (var2_3 != null) {
                    try {
                        var2_3.close();
                    }
                    catch (Exception var13_18) {
                        // empty catch block
                    }
                }
                Transport.connectFlag = false;
                return var6_8;
            }
            var12_14 = null;
            if (var2_3 == null) return (char[])var3_4;
        }
        catch (Throwable var11_20) {
            var12_16 = null;
            if (var2_3 == null) throw var11_20;
            ** try [egrp 7[TRYBLOCK] [7 : 238->245)] { 
lbl53:
            // 1 sources

            var2_3.close();
            throw var11_20;
lbl55:
            // 1 sources

            catch (Exception var13_19) {
                // empty catch block
            }
            throw var11_20;
        }
        try {}
        catch (Exception var13_17) {}
        var2_3.close();
        return (char[])var3_4;
        return (char[])var3_4;
        finally {
            Transport.connectFlag = false;
        }
    }

    public static Object connectToServer(int n) {
        return Transport.connectToServer("localhost", n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object connectToServer(String string, int n) {
        try {
            Object object = thisClass;
            synchronized (object) {
                block11: {
                    if (!connectFlag) break block11;
                    String string2 = "connectToServer is busy, try again later";
                    return string2;
                }
                connectFlag = true;
            }
            object = null;
            try {
                Socket socket = new Socket(string, n);
                socket.setTcpNoDelay(true);
                object = new Transport("client", socket);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                connectFlag = false;
                return exception2;
            }
            Object object2 = object;
            return object2;
        }
        finally {
            connectFlag = false;
        }
    }

    public synchronized boolean disconnect() {
        switch (this.state) {
            case -1: {
                return false;
            }
            case 0: {
                if (!this.kind.equals("client")) break;
                this.message(-1, 63, true);
                try {
                    Thread.sleep(100L);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            this.state = -1;
            this.socket = null;
            this.inStream = null;
            this.outStream = null;
            this.socket.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object doServer(Object object) {
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        Object object2 = "";
        Class<?> clazz = object.getClass();
        try {
            method = clazz.getMethod("doMessage", Integer.TYPE, thisClass);
            if (Integer.TYPE != method.getReturnType()) {
                method = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method2 = clazz.getMethod("doRequest", "".getClass(), Integer.TYPE, new int[0].getClass(), new String[0].getClass(), new double[0].getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method3 = clazz.getMethod("doInvoke", new TranStruct[0].getClass());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.oneWay = 0;
        while (this.state == 0) {
            int n = this.streamInCode();
            switch (n) {
                case 15: {
                    this.oneWay = 1;
                    break;
                }
                case 63: {
                    this.disconnect();
                    object2 = "Disconnected";
                    break;
                }
                case 17: {
                    object2 = this.doServerMessage(object, method);
                    this.oneWay = 0;
                    break;
                }
                case 18: {
                    object2 = this.doServerRequest(object, method2);
                    this.oneWay = 0;
                    break;
                }
                case 19: {
                    object2 = this.doServerInvoke();
                    break;
                }
                case 20: {
                    object2 = this.doServerArglist(object, method3);
                    break;
                }
                default: {
                    object2 = "Bad code " + n;
                }
            }
            if (this.stringEqual("", object2)) continue;
            return object2;
        }
        return "Bad server state";
    }

    boolean stringEqual(Object object, Object object2) {
        if (this.stringP(object) && this.stringP(object2)) {
            return ((String)object).equals((String)object2);
        }
        return false;
    }

    boolean stringP(Object object) {
        return object.getClass().getName().equals("java.lang.String");
    }

    int streamInInt() throws IOException {
        return (Integer)this.streamInValue();
    }

    private Object doServerMessage(Object object, Object object2) {
        int n = 0;
        int n2 = -1;
        try {
            n2 = this.portInInt();
        }
        catch (Exception exception) {
            n2 = -1;
        }
        if (n2 <= 0) {
            return "Bad message code " + n2;
        }
        n = -1;
        if (object2 != null) {
            try {
                n = (Integer)((Method)object2).invoke(object, new Integer(n2), this);
            }
            catch (Exception exception) {
                if (this.oneWay == 0) {
                    this.respond(exception);
                }
                if (this.debugP(1)) {
                    return "Message " + n2 + " throws " + exception;
                }
                return "";
            }
        }
        try {
            if (this.oneWay == 0) {
                this.respond(n);
            }
        }
        catch (Exception exception) {
            return "Respond to " + n2 + " throws " + exception;
        }
        return "";
    }

    private Object doServerRequest(Object object, Object object2) {
        Object object3 = "No handler";
        String string = "";
        int n = 0;
        if (object2 != null) {
            try {
                string = (String)this.streamInValue();
                n = this.streamInInt();
                int[] nArray = (int[])this.streamInValue();
                String[] stringArray = (String[])this.streamInValue();
                double[] dArray = (double[])this.streamInValue();
                object3 = ((Method)object2).invoke(object, string, new Integer(n), nArray, stringArray, dArray);
            }
            catch (Exception exception) {
                if (this.oneWay == 0) {
                    this.respond(exception);
                }
                return "Request " + string + " " + n + " throws " + exception;
            }
        }
        try {
            if (this.oneWay == 0) {
                this.reply(object3);
            }
        }
        catch (Exception exception) {
            return "Reply to " + string + " " + n + " throws " + exception;
        }
        return "";
    }

    private Object doServerInvoke() {
        int n = -1;
        TranStruct[] tranStructArray = null;
        try {
            n = this.portInInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n < 0) {
            return "Bad invoke length " + n;
        }
        tranStructArray = new TranStruct[n];
        if (this.debugP(2)) {
            System.out.println("Transport.doInvoke length=" + n);
        }
        this.iData = new Object[]{new Integer(0), new Integer(n), tranStructArray};
        return "";
    }

    private Object doServerArglist(Object object, Object object2) {
        if (this.iData == null) {
            return "bad server state";
        }
        Object[] objectArray = this.iData;
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        Object object3 = objectArray[2];
        TranStruct[] tranStructArray = (TranStruct[])object3;
        int n3 = -1;
        try {
            n3 = this.portInInt();
            if (n3 != n) {
                return "protocol error";
            }
            tranStructArray[n3] = this.newTS(n3, "Transport.doInvoke arg=");
        }
        catch (Exception exception) {
            return "doInvokeArglist throws " + exception;
        }
        if (++n == n2) {
            Object[] objectArray2;
            if (this.debugP(2)) {
                System.out.println("Transport.doInvoke calling");
            }
            try {
                objectArray2 = (Object[])((Method)object2).invoke(object, new Object[]{tranStructArray});
            }
            catch (Exception exception) {
                if (this.oneWay == 0) {
                    this.respond(exception);
                }
                return "doInvoke throws " + exception;
            }
            if (this.debugP(2)) {
                System.out.println("Transport.doInvoke returns");
            }
            if (this.oneWay == 0) {
                try {
                    int n4 = objectArray2.length;
                    if (this.debugP(2)) {
                        System.out.println("Transport.doInvoke result length=" + n4);
                    }
                    this.streamOutCode(35);
                    this.portOut(n4);
                    this.streamOutFlush();
                    for (int i = 0; i < n4; ++i) {
                        this.sendResultPart(i, (TranStruct)objectArray2[i]);
                    }
                }
                catch (Exception exception) {
                    return "sendResultPart throws " + exception;
                }
            } else {
                this.oneWay = 0;
            }
            this.iData = null;
        } else {
            objectArray[0] = new Integer(n);
        }
        return "";
    }

    TranStruct newTS(int n, String string) throws IOException {
        String string2 = (String)this.streamInValue();
        int n2 = this.streamInInt();
        int[] nArray = (int[])this.streamInValue();
        String[] stringArray = (String[])this.streamInValue();
        double[] dArray = (double[])this.streamInValue();
        if (this.debugP(2)) {
            System.out.println(string + n);
        }
        TranStruct tranStruct = new TranStruct(string2, n2, nArray, stringArray, dArray);
        switch (0xE000 & n2) {
            case 8192: 
            case 16384: 
            case 24576: {
                tranStruct.setExdata(this.streamInValue());
            }
        }
        return tranStruct;
    }

    public Object message(int n) {
        return this.message(n, 17, false);
    }

    public Object message(int n, boolean bl) {
        return this.message(n, 17, bl);
    }

    synchronized String grabSoftLock(String string) {
        Thread thread = Thread.currentThread();
        if (this.softLock == null) {
            this.softLock = thread;
        } else {
            if (this.softLock == thread) {
                return "Recursive call to" + string;
            }
            while (this.softLock != null) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            this.softLock = thread;
        }
        return "";
    }

    synchronized void dropSoftLock() {
        if (this.softLock == null) {
            return;
        }
        this.softLock = null;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Object message(int var1_1, int var2_2, boolean var3_3) {
        try {
            var4_4 = this.grabSoftLock("message()");
            if (var4_4.length() > 0) {
                var5_5 = var4_4;
                return var5_5;
            }
            var5_6 = this.state;
            var6_7 = 0;
            var7_8 = "";
            var8_9 = var7_8;
            try {
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        if (var3_3) {
                            var6_7 = this.streamOutCode(15);
                        }
                        if (var6_7 >= 0) {
                            var6_7 = this.streamOutCode(var2_2);
                        }
                        if (var6_7 >= 0 && var1_1 >= 0) {
                            var6_7 = this.portOut(var1_1);
                        }
                        if (var6_7 >= 0) {
                            var6_7 = this.streamOutFlush();
                        }
                        if (var6_7 >= 0 && !var3_3) {
                            var7_8 = this.responseIn();
                            ** break;
                        }
lbl25:
                        // 3 sources

                        break;
                    }
                    default: {
                        var6_7 = -102;
                        break;
                    }
                }
            }
            finally {
                this.state = var5_6;
            }
            if (var7_8 == var8_9) {
                var9_11 = new Integer(var6_7);
                return var9_11;
            }
            var9_12 = var7_8;
            return var9_12;
        }
        finally {
            this.dropSoftLock();
        }
    }

    public Object request(String string) {
        return this.request(string, 0, new int[0], new String[0], new double[0]);
    }

    public Object request(String string, int n) {
        return this.request(string, n, new int[0], new String[0], new double[0]);
    }

    public Object request(String string, int n, int[] nArray) {
        return this.request(string, n, nArray, new String[0], new double[0]);
    }

    public Object request(String string, int n, int[] nArray, String[] stringArray) {
        return this.request(string, n, nArray, stringArray, new double[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object request(String string, int n, int[] nArray, String[] stringArray, double[] dArray) {
        try {
            String string2 = this.grabSoftLock("request()");
            if (string2.length() > 0) {
                Object[] objectArray = new Object[]{new Integer(-111), string2};
                return objectArray;
            }
            int n2 = this.state;
            int n3 = 0;
            if (!this.kind.equals("client")) {
                Object[] objectArray = new Object[]{new Integer(-101), "request"};
                return objectArray;
            }
            try {
                switch (this.state) {
                    case 0: {
                        Object object;
                        this.state = 3;
                        n3 = this.streamOutCode(18);
                        if (n3 >= 0) {
                            n3 = this.streamOut(string);
                        }
                        if (n3 >= 0) {
                            n3 = this.streamOut(n);
                        }
                        if (n3 >= 0) {
                            n3 = this.streamOut(nArray);
                        }
                        if (n3 >= 0) {
                            n3 = this.streamOutStrings(string, stringArray);
                        }
                        if (n3 >= 0) {
                            n3 = this.streamOut(dArray);
                        }
                        if (n3 < 0) break;
                        Object object2 = object = this.replyIn();
                        return object2;
                    }
                }
                n3 = -102;
            }
            finally {
                this.state = n2;
            }
            Object[] objectArray = new Object[]{new Integer(n3), "request"};
            return objectArray;
        }
        finally {
            this.dropSoftLock();
        }
    }

    int streamOutStrings(String string, String[] stringArray) {
        if (string.equalsIgnoreCase(lispHomeName)) {
            return this.streamOut(new String[0]);
        }
        return this.streamOut(stringArray);
    }

    public Object invoke(TranStruct[] tranStructArray) {
        return this.invoke(tranStructArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(TranStruct[] tranStructArray, boolean bl) {
        try {
            String string = this.grabSoftLock("invoke()");
            if (string.length() > 0) {
                Object[] objectArray = new Object[]{new Integer(-111), string};
                return objectArray;
            }
            int n = this.state;
            int n2 = 0;
            if (!this.kind.equals("client")) {
                Object[] objectArray = new Object[]{new Integer(-101), "invoke"};
                return objectArray;
            }
            try {
                switch (this.state) {
                    case 0: {
                        this.state = 5;
                        if (bl) {
                            n2 = this.streamOutCode(15);
                        }
                        if (n2 >= 0) {
                            n2 = this.streamOutCode(19);
                        }
                        if (n2 >= 0) {
                            n2 = this.portOut(tranStructArray.length);
                        }
                        if (n2 >= 0) {
                            n2 = this.streamOutFlush();
                        }
                        if (n2 >= 0) {
                            for (int i = 0; i < tranStructArray.length; ++i) {
                                if (null == tranStructArray[i] || n2 < 0) continue;
                                n2 = this.invokeArg(i, tranStructArray[i]);
                            }
                        }
                        if (bl) {
                            Object[] objectArray = new Object[]{};
                            return objectArray;
                        }
                        if (n2 >= 0) {
                            Object object = this.resultIn();
                            if (this.debugP(1)) {
                                System.out.println(this.kind + " invoke =>" + " isArrayLen:" + TranStruct.isArrayLen(object) + " isArrayOfLen:" + TranStruct.isArrayOfLen(object) + "  " + object);
                            }
                            Object object2 = object;
                            return object2;
                        }
                        break;
                    }
                    default: {
                        n2 = -102;
                        break;
                    }
                }
            }
            finally {
                this.state = n;
            }
            Object[] objectArray = new Object[]{new Integer(n2), "invoke"};
            return objectArray;
        }
        finally {
            this.dropSoftLock();
        }
    }

    int invokeArg(int n, TranStruct tranStruct) {
        int n2;
        switch (this.state) {
            case 5: {
                n2 = this.sendTS(20, n, tranStruct, "invokeArg");
                break;
            }
            default: {
                n2 = -102;
            }
        }
        return n2;
    }

    int sendTS(int n, int n2, TranStruct tranStruct, String string) {
        int n3;
        if (this.debugP(2)) {
            System.out.println(string + n2);
        }
        if ((n3 = this.streamOutCode(n)) >= 0) {
            n3 = this.portOut(n2);
        }
        if (n3 >= 0) {
            n3 = this.streamOut(tranStruct.home);
        }
        if (n3 >= 0) {
            n3 = this.streamOut(tranStruct.type);
        }
        if (n3 >= 0) {
            n3 = this.streamOut(tranStruct.nums);
        }
        if (n3 >= 0) {
            n3 = this.streamOutStrings(tranStruct.home, tranStruct.strings);
        }
        if (n3 >= 0) {
            n3 = this.streamOut(tranStruct.reals);
        }
        Object object = tranStruct.getExdata();
        switch (tranStruct.type & 0xE000) {
            case 0: {
                break;
            }
            case 8192: {
                if (object == null) {
                    object = new byte[0];
                }
                this.streamOut((byte[])object);
                break;
            }
            case 16384: {
                if (object == null) {
                    object = new short[0];
                }
                this.streamOut((short[])object);
                break;
            }
            case 24576: {
                if (object == null) {
                    object = new float[0];
                }
                this.streamOut((float[])object);
            }
        }
        this.streamOutFlush();
        return n3;
    }

    public synchronized int respond(int n) {
        this.streamOutCode(33);
        this.portOut(n);
        this.streamOutFlush();
        return 0;
    }

    public synchronized int respond(Exception exception) {
        this.streamOutCode(62);
        this.portOut(exception.toString());
        this.streamOutFlush();
        return 0;
    }

    public synchronized int reply(Object object) {
        this.streamOutCode(34);
        this.streamOut(object);
        this.streamOutFlush();
        return 0;
    }

    public synchronized int sendResultPart(int n, TranStruct tranStruct) {
        return this.sendTS(36, n, tranStruct, "Transport.doInvoke resultPart ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object responseIn() {
        block18: {
            var1_1 = this.state;
            var2_2 = 0;
            var3_3 = "";
            var4_4 = var3_3;
            if (!this.kind.equals("client")) {
                return "responseIn: ERR_PORT_CLASS";
            }
            try {
                switch (this.state) {
                    case 1: {
                        this.streamOutFlush();
                        this.state = 2;
                        switch (this.streamInCode()) {
                            case 33: {
                                try {
                                    var2_2 = this.portInInt();
                                    ** break;
lbl18:
                                    // 1 sources

                                }
                                catch (Exception var5_5) {
                                    var3_3 = "responseIn->portInInt: " + var5_5;
                                    ** break;
                                }
lbl22:
                                // 1 sources

                                break block18;
                            }
                            case 62: {
                                try {
                                    var3_3 = this.portInString();
                                    ** break;
lbl27:
                                    // 1 sources

                                }
                                catch (Exception var5_6) {
                                    var3_3 = "responseIn->portInString: " + var5_6;
                                    ** break;
                                }
lbl31:
                                // 1 sources

                                break block18;
                            }
                            case 18: {
                                var3_3 = "responseIn: ERR_CALLBACK";
                                ** break;
lbl35:
                                // 1 sources

                                break block18;
                            }
                        }
                        var3_3 = "responseIn: ERR_PROTOCOL";
                        ** break;
lbl38:
                        // 1 sources

                        break;
                    }
                    default: {
                        var3_3 = "responseIn: ERR_PORT_STATE";
                        break;
                    }
                }
            }
            finally {
                this.state = var1_1;
            }
        }
        if (var3_3 == var4_4) {
            var3_3 = new Integer(var2_2);
        }
        if (this.debugP(1)) {
            System.out.println(this.kind + " responseIn " + var3_3);
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object replyIn() {
        Object object;
        block19: {
            int n = this.state;
            boolean bl = false;
            object = null;
            if (!this.kind.equals("client")) {
                return "replyIn: ERR_PORT_CLASS";
            }
            try {
                switch (this.state) {
                    case 3: {
                        this.streamOutFlush();
                        this.state = 4;
                        switch (this.streamInCode()) {
                            case 34: {
                                try {
                                    object = this.streamInValue();
                                }
                                catch (Exception exception) {
                                    object = exception;
                                }
                                if (this.debugP(1)) {
                                    System.out.println(this.kind + " replyIn " + object);
                                }
                                Object object2 = object;
                                return object2;
                            }
                            case 62: {
                                try {
                                    object = this.portInString();
                                }
                                catch (Exception exception) {
                                    object = exception;
                                }
                                if (this.debugP(1)) {
                                    System.out.println(this.kind + " replyIn Err" + object);
                                    break;
                                }
                                break block19;
                            }
                            case 18: {
                                object = "replyIn: ERR_CALLBACK";
                                break;
                            }
                            default: {
                                object = "replyIn: ERR_PROTOCOL";
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        object = "replyIn: ERR_PORT_STATE";
                        break;
                    }
                }
            }
            finally {
                this.state = n;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object resultIn() {
        Object[] objectArray;
        block19: {
            int n = this.state;
            boolean bl = false;
            if (!this.kind.equals("client")) {
                return "resultIn: ERR_PORT_CLASS";
            }
            try {
                switch (this.state) {
                    case 5: {
                        this.streamOutFlush();
                        this.state = 6;
                        switch (this.streamInCode()) {
                            case 35: {
                                try {
                                    int n2 = this.portInInt();
                                    Object[] objectArray2 = new Object[n2];
                                    if (this.debugP(1)) {
                                        System.out.println(this.kind + " resultIn " + n2);
                                    }
                                    for (int i = 0; i < n2; ++i) {
                                        objectArray2[i] = this.resultPartIn(i);
                                    }
                                    objectArray = objectArray2;
                                }
                                catch (Exception exception) {
                                    objectArray = exception;
                                }
                                break;
                            }
                            case 62: {
                                try {
                                    objectArray = this.portInString();
                                }
                                catch (Exception exception) {
                                    objectArray = exception;
                                }
                                if (this.debugP(1)) {
                                    System.out.println(this.kind + " resultIn Err" + objectArray);
                                    break;
                                }
                                break block19;
                            }
                            case 18: {
                                objectArray = "resultIn: ERR_CALLBACK";
                                break;
                            }
                            default: {
                                objectArray = "resultIn: ERR_PROTOCOL";
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        objectArray = "resultIn: ERR_PORT_STATE";
                        break;
                    }
                }
            }
            finally {
                this.state = n;
            }
        }
        return objectArray;
    }

    Object resultPartIn(int n) {
        int n2 = this.streamInCode();
        switch (n2) {
            case 36: {
                try {
                    int n3 = this.portInInt();
                    if (n != n3) {
                        return new Object[]{new Integer(-104), new Integer(n), new Integer(n3), "resultPartIn"};
                    }
                    return this.newTS(n3, "resultPartIn");
                }
                catch (Exception exception) {
                    return exception;
                }
            }
        }
        return new Object[]{new Integer(-104), new Integer(n2), "resultPartIn"};
    }

    int streamOutFlush() {
        return this.portFlush();
    }

    int streamOutCode(int n) {
        return this.portOut((byte)n);
    }

    int streamOut(Object object) {
        if (object == null) {
            return this.streamOutCode(96);
        }
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        if (string.equals("java.lang.Integer")) {
            return this.streamOut((Integer)object);
        }
        if (string.equals("java.lang.String")) {
            return this.streamOut((String)object);
        }
        if (string.equals("[I")) {
            return this.streamOut((int[])object);
        }
        if (string.equals("[D")) {
            return this.streamOut((double[])object);
        }
        if (string.equals("[Ljava.lang.String;")) {
            return this.streamOut((String[])object);
        }
        return -106;
    }

    int streamOut(String string) {
        if (this.debugP(2)) {
            System.out.println(this.kind + " streamOut STRING: " + string);
        }
        this.portOut((byte)66);
        return this.portOut(string);
    }

    int streamOut(int n) {
        if (this.debugP(2)) {
            System.out.println(this.kind + " streamOut INT: " + n);
        }
        this.portOut((byte)65);
        return this.portOut(n);
    }

    int streamOut(byte[] byArray) {
        if (0 == byArray.length) {
            if (this.debugP(2)) {
                System.out.println(this.kind + " streamOut EMPTY_SEQB");
            }
            this.portOut((byte)104);
            return 0;
        }
        if (byArray.length >= 0x1000000) {
            return -107;
        }
        if (this.debugP(2)) {
            System.out.println(this.kind + " streamOut SEQBYTE " + byArray.length);
        }
        this.portOut((byte)105);
        this.portOut(byArray.length);
        this.portOut(byArray);
        return byArray.length;
    }

    int streamOut(short[] sArray) {
        if (0 == sArray.length) {
            if (this.debugP(2)) {
                System.out.println(this.kind + " streamOut EMPTY_SEQK");
            }
            this.portOut((byte)106);
            return 0;
        }
        if (sArray.length >= 0x1000000) {
            return -107;
        }
        if (this.debugP(2)) {
            System.out.println(this.kind + " streamOut SEQSHORT " + sArray.length);
        }
        this.portOut((byte)107);
        this.portOut(sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            this.portOut(sArray[i]);
        }
        return sArray.length;
    }

    int streamOut(int[] nArray) {
        if (0 == nArray.length) {
            if (this.debugP(2)) {
                System.out.println(this.kind + " streamOut EMPTY_SEQI");
            }
            this.portOut((byte)98);
            return 0;
        }
        if (nArray.length >= 0x1000000) {
            return -107;
        }
        if (this.debugP(2)) {
            System.out.println(this.kind + " streamOut SEQINT " + nArray.length);
        }
        this.portOut((byte)99);
        this.portOut(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.portOut(nArray[i]);
        }
        return nArray.length;
    }

    int streamOut(float[] fArray) {
        if (0 == fArray.length) {
            if (this.debugP(2)) {
                System.out.println(this.kind + " streamOut EMPTY_SEQF");
            }
            this.portOut((byte)110);
            return 0;
        }
        if (fArray.length >= 0x1000000) {
            return -107;
        }
        if (this.debugP(2)) {
            System.out.println(this.kind + " streamOut SEQFLOAT " + fArray.length);
        }
        this.portOut((byte)111);
        this.portOut(fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            this.portOut(fArray[i]);
        }
        return fArray.length;
    }

    int streamOut(double[] dArray) {
        if (0 == dArray.length) {
            if (this.debugP(2)) {
                System.out.println(this.kind + " streamOut EMPTY_SEQR");
            }
            this.portOut((byte)102);
            return 0;
        }
        if (dArray.length >= 0x1000000) {
            return -107;
        }
        if (this.debugP(2)) {
            System.out.println(this.kind + " streamOut SEQREAL " + dArray.length);
        }
        this.portOut((byte)103);
        this.portOut(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            this.portOut(dArray[i]);
        }
        return dArray.length;
    }

    int streamOut(String[] stringArray) {
        if (0 == stringArray.length) {
            if (this.debugP(2)) {
                System.out.println(this.kind + " streamOut EMPTY_SEQS");
            }
            this.portOut((byte)100);
            return 0;
        }
        if (stringArray.length >= 0x1000000) {
            return -107;
        }
        if (this.debugP(2)) {
            System.out.println(this.kind + " streamOut SEQSTRING " + stringArray.length);
        }
        this.portOut((byte)101);
        this.portOut(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.portOut(stringArray[i]);
        }
        return stringArray.length;
    }

    int streamInCode() {
        if (this.haveCode == 1000000) {
            return this.portIn_8();
        }
        int n = this.haveCode;
        this.haveCode = 1000000;
        return n;
    }

    int streamInCode(int n) {
        if (this.haveCode == 1000000) {
            this.haveCode = n;
            return n;
        }
        return -104;
    }

    Object streamInValue() throws IOException {
        String string;
        Object object = null;
        int n = this.streamInCode();
        switch (n) {
            case 66: {
                string = "STRING";
                object = this.portInString();
                break;
            }
            case 65: {
                string = "INT";
                object = new Integer(this.portInInt());
                break;
            }
            case 99: {
                string = "SEQINT";
                object = this.portInSeqInt();
                break;
            }
            case 101: {
                string = "SEQSTRING";
                object = this.portInSeqString();
                break;
            }
            case 103: {
                string = "SEQREAL";
                object = this.portInSeqReal();
                break;
            }
            case 105: {
                string = "SEQBYTE";
                object = this.portInSeqByte();
                break;
            }
            case 107: {
                string = "SEQSHORT";
                object = this.portInSeqShort();
                break;
            }
            case 111: {
                string = "SEQFLOAT";
                object = this.portInSeqFloat();
                break;
            }
            case 98: {
                string = "EMPTY_SEQI";
                object = new int[0];
                break;
            }
            case 102: {
                string = "EMPTY_SEQR";
                object = new double[0];
                break;
            }
            case 100: {
                string = "EMPTY_SEQS";
                object = new String[]{};
                break;
            }
            case 104: {
                string = "EMPTY_SEQB";
                object = new byte[0];
                break;
            }
            case 106: {
                string = "EMPTY_SEQK";
                object = new short[0];
                break;
            }
            case 110: {
                string = "EMPTY_SEQF";
                object = new float[0];
                break;
            }
            case 96: {
                string = "NULL";
                object = null;
                break;
            }
            default: {
                string = "NOT_DATA";
                object = null;
                this.streamInCode(n);
            }
        }
        if (this.debugP(2)) {
            System.out.println(this.kind + " streamIn " + string + ": " + object);
        }
        return object;
    }

    int portIn_8() {
        int n;
        try {
            n = this.inStream.read();
            if (this.debugP(5)) {
                System.out.println(this.kind + " portIn_8: " + n);
            }
        }
        catch (IOException iOException) {
            n = -108;
        }
        return n;
    }

    int portIn_16() {
        int n = this.portIn_8();
        if (n < 0) {
            return n;
        }
        int n2 = this.portIn_8();
        if (n2 < 0) {
            return n2;
        }
        n2 = n + (n2 << 8);
        if (this.debugP(4)) {
            System.out.println(this.kind + " portIn_16: " + n2);
        }
        return n2;
    }

    int portInIntOLD() throws IOException {
        int n = this.portIn_8();
        if (n < 0) {
            throw new IOException("portInInt->portIn_8=" + n);
        }
        int n2 = 0;
        for (int i = 0; i < 32; i += 8) {
            int n3 = this.portIn_8();
            if (n3 < 0) {
                throw new IOException("portInInt->portIn_8=" + n3);
            }
            n2 |= n3 << i;
        }
        if (n != 0) {
            n2 = -n2;
        }
        if (this.debugP(3)) {
            System.out.println(this.kind + " portInInt: " + n2);
        }
        return n2;
    }

    int portInInt() throws IOException {
        boolean bl;
        int n;
        int n2 = this.portIn_8();
        if (n2 < 0) {
            throw new IOException("portInInt->portIn_8=" + n2);
        }
        switch (n2) {
            case 0: {
                n = 4;
                bl = false;
                break;
            }
            case 1: {
                n = 4;
                bl = true;
                break;
            }
            case 2: {
                n = 3;
                bl = false;
                break;
            }
            case 3: {
                n = 3;
                bl = true;
                break;
            }
            case 4: {
                n = 2;
                bl = false;
                break;
            }
            case 5: {
                n = 2;
                bl = true;
                break;
            }
            case 6: {
                n = 1;
                bl = false;
                break;
            }
            case 7: {
                n = 1;
                bl = true;
                break;
            }
            case 8: {
                return -1;
            }
            default: {
                return n2 - 9;
            }
        }
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            int n5 = this.portIn_8();
            if (n5 < 0) {
                throw new IOException("portInInt->portIn_8=" + n5);
            }
            n3 |= n5 << n4;
            n4 += 8;
        }
        if (bl) {
            n3 = -n3;
        }
        if (this.debugP(3)) {
            System.out.println(this.kind + " portInInt: " + n3);
        }
        return n3;
    }

    String portInString() throws IOException {
        int n = this.portInInt();
        if (n < 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.portIn_16();
            if (n2 < 0) {
                throw new IOException("portIn=" + n2);
            }
            stringBuffer.append((char)n2);
        }
        String string = stringBuffer.toString();
        if (this.debugP(3)) {
            System.out.println(this.kind + " portInString: " + string);
        }
        return string;
    }

    int[] portInSeqInt() throws IOException {
        int n = this.portInInt();
        if (this.debugP(3)) {
            System.out.println(this.kind + " portInSeqInt: " + n);
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.portInInt();
        }
        return nArray;
    }

    short[] portInSeqShort() throws IOException {
        int n = this.portInInt();
        if (this.debugP(3)) {
            System.out.println(this.kind + " portInSeqShort: " + n);
        }
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)this.portInInt();
        }
        return sArray;
    }

    byte[] portInSeqByte() throws IOException {
        int n = this.portInInt();
        if (this.debugP(3)) {
            System.out.println(this.kind + " portInSeqByte: " + n);
        }
        byte[] byArray = new byte[n];
        int n2 = this.inStream.read(byArray);
        int n3 = n - n2;
        if (n2 < n) {
            throw new IOException("streamInSeqByte short: " + n3);
        }
        return byArray;
    }

    String[] portInSeqString() throws IOException {
        int n = this.portInInt();
        if (this.debugP(3)) {
            System.out.println(this.kind + " portInSeqString: " + n);
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.portInString();
        }
        return stringArray;
    }

    float[] portInSeqFloat() throws IOException {
        int n = this.portInInt();
        if (this.debugP(3)) {
            System.out.println(this.kind + " portInSeqFloat: " + n);
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.portInFloat();
        }
        return fArray;
    }

    double[] portInSeqReal() throws IOException {
        int n = this.portInInt();
        if (this.debugP(3)) {
            System.out.println(this.kind + " portInSeqReal: " + n);
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.portInReal();
        }
        return dArray;
    }

    double portInReal() throws IOException {
        int n = this.portIn_8();
        if (n < 0) {
            throw new IOException("portInReal->portIn_8=" + n);
        }
        long l = this.portIn_8();
        if (l < 0L) {
            throw new IOException("portInReal->portIn_8=" + l);
        }
        long l2 = this.portIn_8();
        if (l2 < 0L) {
            throw new IOException("portInReal->portIn_8=" + l2);
        }
        long l3 = 0L;
        for (int i = 0; i < 51; i += 8) {
            long l4 = this.portIn_8();
            if (l4 < 0L) {
                throw new IOException("portInReal->portIn_8=" + l4);
            }
            l3 |= l4 << i;
        }
        l3 |= (l2 << 8 | l) << 52;
        if (n != 0) {
            l3 |= Long.MIN_VALUE;
        }
        double d = Double.longBitsToDouble(l3);
        if (this.debugP(3)) {
            System.out.println(this.kind + " portInReal: " + d);
        }
        return d;
    }

    float portInFloat() throws IOException {
        int n = this.portIn_8();
        if (n < 0) {
            throw new IOException("portInFloat->portIn_8=" + n);
        }
        int n2 = this.portIn_8();
        if (n2 < 0) {
            throw new IOException("portInFloat->portIn_8=" + n2);
        }
        int n3 = this.portIn_8();
        if (n3 < 0) {
            throw new IOException("portInFloat->portIn_8=" + n3);
        }
        int n4 = 0;
        for (int i = 0; i < 23; i += 8) {
            int n5 = this.portIn_8();
            if (n5 < 0) {
                throw new IOException("portInFloat->portIn_8=" + n5);
            }
            n4 |= n5 << i;
        }
        n4 |= (n3 << 8 | n2) << 23;
        if (n != 0) {
            n4 |= Integer.MIN_VALUE;
        }
        float f = Float.intBitsToFloat(n4);
        if (this.debugP(3)) {
            System.out.println(this.kind + " portInFloat: " + f);
        }
        return f;
    }

    int portFlush() {
        if (this.endpos > 0) {
            try {
                if (this.debugP(4)) {
                    System.out.println(this.kind + " portFlush " + this.endpos + " bytes: " + this.buffer[0] + " " + this.buffer[1] + "...");
                }
                this.outStream.write(this.buffer, 0, this.endpos);
                this.outStream.flush();
            }
            catch (Exception exception) {
                return -108;
            }
        }
        this.endpos = 0;
        return 0;
    }

    int portReserveSpace(int n) {
        int n2 = 0;
        if (this.endpos + n > this.buffer.length) {
            n2 = this.portFlush();
        }
        if (n2 < 0) {
            return n2;
        }
        return this.endpos + n;
    }

    int portOut(byte by) {
        int n = this.portReserveSpace(1);
        if (n < 0) {
            return n;
        }
        if (this.debugP(3)) {
            System.out.println(this.kind + " portOut byte: " + by);
        }
        this.bufferOut_8(by);
        return this.endpos;
    }

    int portOut(byte[] byArray) {
        int n = this.buffer.length - this.endpos;
        if (n < byArray.length) {
            this.portFlush();
        }
        for (int i = 0; i < byArray.length; i += 100) {
            int n2 = this.portReserveSpace(100);
            if (n2 < 0) {
                return n2;
            }
            for (int j = i; j < byArray.length; ++j) {
                this.bufferOut_8(byArray[j]);
            }
        }
        return this.endpos;
    }

    int portOut(char c) {
        int n = this.portReserveSpace(2);
        if (n < 0) {
            return n;
        }
        if (this.debugP(4)) {
            System.out.println(this.kind + " portOut char: " + c);
        }
        this.bufferOut_16(c);
        return this.endpos;
    }

    int portOut(short s) {
        return this.portOut((int)s);
    }

    int portOut(int n) {
        int n2;
        int n3;
        int n4;
        long l = n;
        if (l < 0L) {
            l = -l;
            if (varInt == 0) {
                n4 = 1;
                n3 = 32;
                n2 = 5;
            } else if (l == 1L) {
                n4 = 8;
                n3 = 0;
                n2 = 1;
            } else if (l < 256L) {
                n4 = 7;
                n3 = 8;
                n2 = 2;
            } else if (l < 65536L) {
                n4 = 5;
                n3 = 16;
                n2 = 3;
            } else if (l < 0x1000000L) {
                n4 = 3;
                n3 = 24;
                n2 = 4;
            } else {
                n4 = 1;
                n3 = 32;
                n2 = 5;
            }
        } else if (varInt == 0) {
            n4 = 0;
            n3 = 32;
            n2 = 5;
        } else if (l < 247L) {
            n4 = n + 9;
            n3 = 0;
            n2 = 1;
        } else if (l < 256L) {
            n4 = 6;
            n3 = 8;
            n2 = 2;
        } else if (l < 65536L) {
            n4 = 4;
            n3 = 16;
            n2 = 3;
        } else if (l < 0x1000000L) {
            n4 = 2;
            n3 = 24;
            n2 = 4;
        } else {
            n4 = 0;
            n3 = 32;
            n2 = 5;
        }
        int n5 = this.portReserveSpace(n2);
        if (n5 < 0) {
            return n5;
        }
        if (this.debugP(3)) {
            System.out.println(this.kind + " portOut int: " + n);
        }
        this.bufferOut_8(n4);
        for (int i = 0; i < n3; i += 8) {
            this.bufferOut_8((int)(0xFFL & l >> i));
        }
        return this.endpos;
    }

    int portOut(float f) {
        int n = this.portReserveSpace(6);
        if (n < 0) {
            return n;
        }
        if (this.debugP(3)) {
            System.out.println(this.kind + " portOut float: " + f);
        }
        int n2 = Float.floatToRawIntBits(f);
        int n3 = 0;
        if (n2 < 0) {
            n2 ^= Integer.MIN_VALUE;
            n3 = 1;
        }
        int n4 = n2 >> 23;
        n2 |= 0x7F800000;
        n2 ^= 0x7F800000;
        this.bufferOut_8(n3);
        this.bufferOut_16(n4);
        for (int i = 0; i < 23; i += 8) {
            this.bufferOut_8((int)(0xFFL & (long)(n2 >> i)));
        }
        return this.endpos;
    }

    int portOut(double d) {
        int n = this.portReserveSpace(10);
        if (n < 0) {
            return n;
        }
        if (this.debugP(3)) {
            System.out.println(this.kind + " portOut double: " + d);
        }
        long l = Double.doubleToRawLongBits(d);
        int n2 = 0;
        if (l < 0L) {
            l ^= Long.MIN_VALUE;
            n2 = 1;
        }
        int n3 = (int)(l >> 52);
        l |= 0x7FF0000000000000L;
        l ^= 0x7FF0000000000000L;
        this.bufferOut_8(n2);
        this.bufferOut_16(n3);
        for (int i = 0; i < 52; i += 8) {
            this.bufferOut_8((int)(0xFFL & l >> i));
        }
        return this.endpos;
    }

    int portOut(String string) {
        if (string == null) {
            int n = varInt == 0 ? this.portOut(0) : this.portOut(-1);
            if (n < 0) {
                return n;
            }
            if (this.debugP(3)) {
                System.out.println(this.kind + " portOut String: " + string);
            }
        } else {
            int n = this.portOut(string.length());
            if (n < 0) {
                return n;
            }
            if (this.debugP(3)) {
                System.out.println(this.kind + " portOut String: " + string);
            }
            for (int i = 0; i < string.length(); ++i) {
                n = this.portOut(string.charAt(i));
                if (n >= 0) continue;
                return n;
            }
        }
        return this.endpos;
    }

    int bufferOut_8(int n) {
        if (this.debugP(5)) {
            System.out.println(this.kind + " bufferOut_8: " + n);
        }
        this.buffer[this.endpos] = (byte)(0xFF & n);
        ++this.endpos;
        return this.endpos;
    }

    int bufferOut_16(int n) {
        if (this.debugP(5)) {
            System.out.println(this.kind + " bufferOut_16: " + n);
        }
        this.buffer[this.endpos] = (byte)(0xFF & n);
        ++this.endpos;
        this.buffer[this.endpos] = (byte)(0xFF & n >> 8);
        ++this.endpos;
        return this.endpos;
    }
}

