/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.random.generators;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.random.generators.Lattice1DGenerator;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.Random;

public class WattsBetaSmallWorldGenerator
extends Lattice1DGenerator {
    private int numNodes = 0;
    private double beta = 0.0;
    private int degree = 0;
    private Random random = new Random();

    public WattsBetaSmallWorldGenerator(int numNodes, double beta, int degree) {
        super(numNodes, true);
        if (numNodes < 10) {
            throw new IllegalArgumentException("Lattice must contain at least 10 vertices.");
        }
        if (degree % 2 != 0) {
            throw new IllegalArgumentException("All nodes must have an even degree.");
        }
        if (beta > 1.0 || beta < 0.0) {
            throw new IllegalArgumentException("Beta must be between 0 and 1.");
        }
        this.numNodes = numNodes;
        this.beta = beta;
        this.degree = degree;
    }

    public ArchetypeGraph generateGraph() {
        int s;
        int i;
        UndirectedSparseGraph g = new UndirectedSparseGraph();
        GraphUtils.addVertices((Graph)g, this.numNodes);
        int upI = 0;
        Indexer id = Indexer.getIndexer(g);
        int numKNeighbors = this.degree / 2;
        for (i = 0; i < this.numNodes; ++i) {
            for (s = 1; s <= numKNeighbors; ++s) {
                Vertex ithVertex = (Vertex)id.getVertex(i);
                upI = this.upIndex(i, s);
                GraphUtils.addEdge(g, ithVertex, (Vertex)id.getVertex(upI));
            }
        }
        for (i = 0; i < this.numNodes; ++i) {
            block3: for (s = 1; s <= numKNeighbors; ++s) {
                double r;
                while ((r = this.random.nextDouble()) < this.beta) {
                    int v = this.random.nextInt(this.numNodes);
                    Vertex vthVertex = (Vertex)id.getVertex(v);
                    Vertex ithVertex = (Vertex)id.getVertex(i);
                    Vertex kthVertex = (Vertex)id.getVertex(this.upIndex(i, s));
                    Edge e = ithVertex.findEdge(kthVertex);
                    if (kthVertex.isNeighborOf(vthVertex) || kthVertex == vthVertex) continue;
                    g.removeEdge(e);
                    GraphUtils.addEdge(g, kthVertex, vthVertex);
                    continue block3;
                }
            }
        }
        return g;
    }
}

