/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import cern.colt.list.DoubleArrayList;
import edu.uci.ics.jung.algorithms.transformation.DirectionTransformer;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hyperedge;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.Hypervertex;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.decorators.NumberVertexValue;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.filters.UnassembledGraph;
import edu.uci.ics.jung.graph.filters.impl.DropSoloNodesFilter;
import edu.uci.ics.jung.graph.impl.AbstractSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseVertex;
import edu.uci.ics.jung.utils.PredicateUtils;
import edu.uci.ics.jung.utils.VertexGenerator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class GraphUtils {
    public static Edge addEdge(Graph g, Vertex v1, Vertex v2) {
        if (v1.getGraph() != g || v2.getGraph() != g) {
            throw new IllegalArgumentException("Vertices not in this graph!");
        }
        if (PredicateUtils.enforcesEdgeConstraint(g, Graph.DIRECTED_EDGE)) {
            return (AbstractSparseEdge)g.addEdge(new DirectedSparseEdge(v1, v2));
        }
        if (PredicateUtils.enforcesEdgeConstraint(g, Graph.UNDIRECTED_EDGE)) {
            return (AbstractSparseEdge)g.addEdge(new UndirectedSparseEdge(v1, v2));
        }
        throw new IllegalArgumentException("Behavior not specified for mixed (directed/undirected) graphs");
    }

    public static void addVertices(Graph g, int count) {
        for (int i = 0; i < count; ++i) {
            g.addVertex(new SparseVertex());
        }
    }

    public static void addDirectedVertices(Graph g, int count) {
        for (int i = 0; i < count; ++i) {
            g.addVertex(new DirectedSparseVertex());
        }
    }

    public static void addUndirectedVertices(Graph g, int count) {
        for (int i = 0; i < count; ++i) {
            g.addVertex(new UndirectedSparseVertex());
        }
    }

    public static Set translateAll(Set s, Graph g) {
        return GraphUtils.getEqualVertices(s, g);
    }

    public static Set getEqualVertices(Set s, ArchetypeGraph g) {
        HashSet<ArchetypeVertex> rv = new HashSet<ArchetypeVertex>();
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            ArchetypeVertex v = (ArchetypeVertex)iter.next();
            ArchetypeVertex v_g = v.getEqualVertex(g);
            if (v_g == null) continue;
            rv.add(v_g);
        }
        return rv;
    }

    public static Set translateAllEdges(Set s, Graph g) {
        return GraphUtils.getEqualEdges(s, g);
    }

    public static Set getEqualEdges(Set s, ArchetypeGraph g) {
        HashSet<ArchetypeEdge> rv = new HashSet<ArchetypeEdge>();
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            ArchetypeEdge e = (ArchetypeEdge)iter.next();
            ArchetypeEdge e_g = e.getEqualEdge(g);
            if (e_g == null) continue;
            rv.add(e_g);
        }
        return rv;
    }

    public static Graph vertexSetToGraph(Set s) {
        if (s.isEmpty()) {
            return null;
        }
        Vertex v = (Vertex)s.iterator().next();
        Graph g = (Graph)v.getGraph();
        return new UnassembledGraph("vertexSetToGraph", s, g.getEdges(), g).assemble();
    }

    public static Graph edgeSetToGraph(Set edges, boolean retain) {
        if (edges.isEmpty()) {
            return null;
        }
        Edge e = (Edge)edges.iterator().next();
        Graph g = (Graph)e.getGraph();
        Graph retval = new UnassembledGraph("edgeSetToGraph", g.getVertices(), edges, g).assemble();
        if (retain) {
            return retval;
        }
        return DropSoloNodesFilter.getInstance().filter(retval).assemble();
    }

    public static ArchetypeGraph union(ArchetypeGraph g1, ArchetypeGraph g2) {
        ArchetypeGraph g = g1.newInstance();
        g.getEdgeConstraints().addAll(CollectionUtils.intersection((Collection)g1.getEdgeConstraints(), (Collection)g2.getEdgeConstraints()));
        Collection vertices = CollectionUtils.union((Collection)g1.getVertices(), (Collection)g2.getVertices());
        Collection edges = CollectionUtils.union((Collection)g1.getEdges(), (Collection)g2.getEdges());
        Iterator v_iter = vertices.iterator();
        while (v_iter.hasNext()) {
            ArchetypeVertex v = (ArchetypeVertex)v_iter.next();
            v.copy(g);
        }
        Iterator e_iter = edges.iterator();
        while (e_iter.hasNext()) {
            ArchetypeEdge e = (ArchetypeEdge)e_iter.next();
            e.copy(g);
        }
        return g;
    }

    public static DirectedGraph transform(Graph uGraph) {
        return DirectionTransformer.toDirected(uGraph);
    }

    public static UndirectedGraph transform(DirectedGraph dGraph) {
        return DirectionTransformer.toUndirected(dGraph);
    }

    public static void copyLabels(StringLabeller source, StringLabeller target) throws StringLabeller.UniqueLabelException {
        Graph g1 = source.getGraph();
        Graph g2 = target.getGraph();
        Set s1 = g1.getVertices();
        Set s2 = g2.getVertices();
        Iterator iter = s1.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            if (!s2.contains(v)) continue;
            target.setLabel((Vertex)v.getEqualVertex(g2), source.getLabel(v));
        }
    }

    public static boolean areEquivalent(ArchetypeGraph g1, ArchetypeGraph g2) {
        return g1 == g2 || ((Object)g1.getVertices()).equals(g2.getVertices()) && ((Object)g1.getEdges()).equals(g2.getEdges());
    }

    public static String printVertices(Collection s, StringLabeller sl) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        sb.append("[");
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(sl.getLabel(v));
        }
        sb.append("]");
        return sb.toString();
    }

    public static void copyValues(ArchetypeGraph g, NumberVertexValue source, NumberVertexValue dest) {
        Iterator iter = g.getVertices().iterator();
        while (iter.hasNext()) {
            ArchetypeVertex v = (ArchetypeVertex)iter.next();
            dest.setNumber(v, source.getNumber(v));
        }
    }

    public static VertexGenerator getVertexGenerator(ArchetypeGraph g) {
        return (VertexGenerator)g.getUserDatum("edu.uci.ics.jung.utils.VertexGenerator");
    }

    public static DoubleArrayList vertexMapToDAL(Map vertex_values, Indexer indexer) {
        DoubleArrayList dal = new DoubleArrayList(vertex_values.size());
        dal.setSize(vertex_values.size());
        Iterator iter = vertex_values.keySet().iterator();
        while (iter.hasNext()) {
            ArchetypeVertex av = (ArchetypeVertex)iter.next();
            double value = ((Number)vertex_values.get(av)).doubleValue();
            dal.set(indexer.getIndex(av), value);
        }
        return dal;
    }

    public static void addVertices(Graph g, Set vertices) {
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            g.addVertex((Vertex)iter.next());
        }
    }

    public static void addVertices(Hypergraph g, Set vertices) {
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            g.addVertex((Hypervertex)iter.next());
        }
    }

    public static void addEdges(Graph g, Set edges) {
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            g.addEdge((Edge)iter.next());
        }
    }

    public static void addEdges(Hypergraph g, Set edges) {
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            g.addEdge((Hyperedge)iter.next());
        }
    }

    public static void removeVertices(Graph g, Set vertices) {
        Iterator iter = new LinkedList(vertices).iterator();
        while (iter.hasNext()) {
            g.removeVertex((Vertex)iter.next());
        }
    }

    public static void removeVertices(Hypergraph g, Set vertices) {
        Iterator iter = new LinkedList(vertices).iterator();
        while (iter.hasNext()) {
            g.removeVertex((Hypervertex)iter.next());
        }
    }

    public static void removeEdges(Graph g, Set edges) {
        Iterator iter = new LinkedList(edges).iterator();
        while (iter.hasNext()) {
            g.removeEdge((Edge)iter.next());
        }
    }

    public static void removeEdges(Hypergraph g, Set edges) {
        Iterator iter = new LinkedList(edges).iterator();
        while (iter.hasNext()) {
            g.removeEdge((Hyperedge)iter.next());
        }
    }
}

