/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.visualization.transform.Transformer;
import edu.uci.ics.jung.visualization.transform.shape.ShapeTransformer;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class AffineTransformer
implements Transformer,
ShapeTransformer {
    protected AffineTransform inverse;
    protected AffineTransform transform = new AffineTransform();

    public AffineTransformer() {
    }

    public AffineTransformer(AffineTransform transform) {
        if (transform != null) {
            this.transform = transform;
        }
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public Point2D inverseTransform(Point2D p) {
        return this.getInverse().transform(p, null);
    }

    public AffineTransform getInverse() {
        if (this.inverse == null) {
            try {
                this.inverse = this.transform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
        }
        return this.inverse;
    }

    public double getScaleX() {
        return this.transform.getScaleX();
    }

    public double getScaleY() {
        return this.transform.getScaleY();
    }

    public double getScale() {
        return Math.sqrt(this.transform.getDeterminant());
    }

    public double getShearX() {
        return this.transform.getShearX();
    }

    public double getShearY() {
        return this.transform.getShearY();
    }

    public double getTranslateX() {
        return this.transform.getTranslateX();
    }

    public double getTranslateY() {
        return this.transform.getTranslateY();
    }

    public Point2D transform(Point2D p) {
        if (p == null) {
            return null;
        }
        return this.transform.transform(p, null);
    }

    public Shape transform(Shape shape) {
        GeneralPath newPath = new GeneralPath();
        float[] coords = new float[6];
        PathIterator iterator = shape.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    Point2D p = this.transform(new Point2D.Float(coords[0], coords[1]));
                    newPath.moveTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 1: {
                    Point2D p = this.transform(new Point2D.Float(coords[0], coords[1]));
                    newPath.lineTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 2: {
                    Point2D p = this.transform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.transform(new Point2D.Float(coords[2], coords[3]));
                    newPath.quadTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY());
                    break;
                }
                case 3: {
                    Point2D p = this.transform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.transform(new Point2D.Float(coords[2], coords[3]));
                    Point2D r = this.transform(new Point2D.Float(coords[4], coords[5]));
                    newPath.curveTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY(), (float)r.getX(), (float)r.getY());
                    break;
                }
                case 4: {
                    newPath.closePath();
                }
            }
            iterator.next();
        }
        return newPath;
    }

    public Shape inverseTransform(Shape shape) {
        GeneralPath newPath = new GeneralPath();
        float[] coords = new float[6];
        PathIterator iterator = shape.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    Point2D p = this.inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.moveTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 1: {
                    Point2D p = this.inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.lineTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 2: {
                    Point2D p = this.inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.inverseTransform(new Point2D.Float(coords[2], coords[3]));
                    newPath.quadTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY());
                    break;
                }
                case 3: {
                    Point2D p = this.inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.inverseTransform(new Point2D.Float(coords[2], coords[3]));
                    Point2D r = this.inverseTransform(new Point2D.Float(coords[4], coords[5]));
                    newPath.curveTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY(), (float)r.getX(), (float)r.getY());
                    break;
                }
                case 4: {
                    newPath.closePath();
                }
            }
            iterator.next();
        }
        return newPath;
    }

    public double getRotation() {
        double[] unitVector = new double[]{0.0, 0.0, 1.0, 0.0};
        double[] result = new double[4];
        this.transform.transform(unitVector, 0, result, 0, 2);
        double dy = Math.abs(result[3] - result[1]);
        double length = Point2D.distance(result[0], result[1], result[2], result[3]);
        double rotation = Math.asin(dy / length);
        if (result[3] - result[1] > 0.0) {
            if (result[2] - result[0] < 0.0) {
                rotation = Math.PI - rotation;
            }
        } else {
            rotation = result[2] - result[0] > 0.0 ? Math.PI * 2 - rotation : (rotation += Math.PI);
        }
        return rotation;
    }

    public String toString() {
        return "Transformer using " + this.transform;
    }
}

