/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.iter;

import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.impl.GraphLayoutPanel;
import samples.preview_new_graphdraw.iter.IterableLayout;

public class LayoutIterator
implements Runnable {
    protected IterableLayout iterableLayout;
    protected GraphLayoutPanel jgp;
    protected boolean stop;
    protected Thread runningThread;
    protected long iterationDelay = 0L;

    public LayoutIterator(GraphLayoutPanel jgp, IterableLayout la) {
        this.jgp = jgp;
        this.iterableLayout = la;
        this.stop = false;
    }

    public void startIterations() {
        this.runningThread = new Thread(this);
        this.stop = false;
        this.runningThread.start();
    }

    public void stopIterations() {
        this.stop = true;
    }

    public void run() {
        while (!this.stop) {
            EmittedLayout el = this.iterableLayout.emit();
            this.jgp.setLayoutDisplay(el);
            if (!this.iterableLayout.isFinite() || !this.iterableLayout.iterationsAreDone()) {
                this.iterableLayout.advance();
            }
            if (this.stop) break;
            if (this.iterationDelay <= 0L) continue;
            try {
                Thread.sleep(this.iterationDelay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setIterationDelay(long i) {
        this.iterationDelay = i;
    }
}

