/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.collections.BulkTest;
import org.apache.commons.collections.IterableMap;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.iterators.AbstractTestMapIterator;
import org.apache.commons.collections.map.AbstractTestMap;

public abstract class AbstractTestIterableMap
extends AbstractTestMap {
    public AbstractTestIterableMap(String testName) {
        super(testName);
    }

    public void testFailFastEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Iterator it = this.map.entrySet().iterator();
        Map.Entry val = it.next();
        this.map.remove(val.getKey());
        try {
            it.next();
            Assert.fail();
        }
        catch (ConcurrentModificationException ex) {
            // empty catch block
        }
        this.resetFull();
        it = this.map.entrySet().iterator();
        it.next();
        this.map.clear();
        try {
            it.next();
            Assert.fail();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void testFailFastKeySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Iterator it = this.map.keySet().iterator();
        Object val = it.next();
        this.map.remove(val);
        try {
            it.next();
            Assert.fail();
        }
        catch (ConcurrentModificationException ex) {
            // empty catch block
        }
        this.resetFull();
        it = this.map.keySet().iterator();
        it.next();
        this.map.clear();
        try {
            it.next();
            Assert.fail();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void testFailFastValues() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Iterator it = this.map.values().iterator();
        it.next();
        this.map.remove(this.map.keySet().iterator().next());
        try {
            it.next();
            Assert.fail();
        }
        catch (ConcurrentModificationException ex) {
            // empty catch block
        }
        this.resetFull();
        it = this.map.values().iterator();
        it.next();
        this.map.clear();
        try {
            it.next();
            Assert.fail();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public BulkTest bulkTestMapIterator() {
        return new InnerTestMapIterator();
    }

    public class InnerTestMapIterator
    extends AbstractTestMapIterator {
        public InnerTestMapIterator() {
            super("InnerTestMapIterator");
        }

        public Object[] addSetValues() {
            return AbstractTestIterableMap.this.getNewSampleValues();
        }

        public boolean supportsRemove() {
            return AbstractTestIterableMap.this.isRemoveSupported();
        }

        public boolean isGetStructuralModify() {
            return AbstractTestIterableMap.this.isGetStructuralModify();
        }

        public boolean supportsSetValue() {
            return AbstractTestIterableMap.this.isSetValueSupported();
        }

        public MapIterator makeEmptyMapIterator() {
            AbstractTestIterableMap.this.resetEmpty();
            return ((IterableMap)AbstractTestIterableMap.this.map).mapIterator();
        }

        public MapIterator makeFullMapIterator() {
            AbstractTestIterableMap.this.resetFull();
            return ((IterableMap)AbstractTestIterableMap.this.map).mapIterator();
        }

        public Map getMap() {
            return AbstractTestIterableMap.this.map;
        }

        public Map getConfirmedMap() {
            return AbstractTestIterableMap.this.confirmed;
        }

        public void verify() {
            super.verify();
            AbstractTestIterableMap.this.verify();
        }
    }
}

