/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.apache.commons.collections.AbstractTestObject;
import org.apache.commons.collections.BulkTest;
import org.apache.commons.collections.collection.AbstractTestCollection;
import org.apache.commons.collections.set.AbstractTestSet;

public abstract class AbstractTestMap
extends AbstractTestObject {
    private static final boolean JDK12;
    protected Map map;
    protected Set entrySet;
    protected Set keySet;
    protected Collection values;
    protected Map confirmed;

    public AbstractTestMap(String testName) {
        super(testName);
    }

    public boolean isPutAddSupported() {
        return true;
    }

    public boolean isPutChangeSupported() {
        return true;
    }

    public boolean isSetValueSupported() {
        return this.isPutChangeSupported();
    }

    public boolean isRemoveSupported() {
        return true;
    }

    public boolean isGetStructuralModify() {
        return false;
    }

    public boolean isSubMapViewsSerializable() {
        return true;
    }

    public boolean isAllowNullKey() {
        return true;
    }

    public boolean isAllowNullValue() {
        return true;
    }

    public boolean isAllowDuplicateValues() {
        return true;
    }

    public Object[] getSampleKeys() {
        Object[] result = new Object[]{"blah", "foo", "bar", "baz", "tmp", "gosh", "golly", "gee", "hello", "goodbye", "we'll", "see", "you", "all", "again", "key", "key2", this.isAllowNullKey() && !JDK12 ? null : "nonnullkey"};
        return result;
    }

    public Object[] getOtherKeys() {
        return this.getOtherNonNullStringElements();
    }

    public Object[] getOtherValues() {
        return this.getOtherNonNullStringElements();
    }

    public Object[] getOtherNonNullStringElements() {
        return new Object[]{"For", "then", "despite", "space", "I", "would", "be", "brought", "From", "limits", "far", "remote", "where", "thou", "dost", "stay"};
    }

    public Object[] getSampleValues() {
        Object[] result = new Object[]{"blahv", "foov", "barv", "bazv", "tmpv", "goshv", "gollyv", "geev", "hellov", "goodbyev", "we'llv", "seev", "youv", "allv", "againv", this.isAllowNullValue() && !JDK12 ? null : "nonnullvalue", "value", this.isAllowDuplicateValues() ? "value" : "value2"};
        return result;
    }

    public Object[] getNewSampleValues() {
        Object[] result = new Object[]{this.isAllowNullValue() && !JDK12 && this.isAllowDuplicateValues() ? null : "newnonnullvalue", "newvalue", this.isAllowDuplicateValues() ? "newvalue" : "newvalue2", "newblahv", "newfoov", "newbarv", "newbazv", "newtmpv", "newgoshv", "newgollyv", "newgeev", "newhellov", "newgoodbyev", "newwe'llv", "newseev", "newyouv", "newallv", "newagainv"};
        return result;
    }

    public void addSampleMappings(Map m) {
        Object[] keys = this.getSampleKeys();
        Object[] values = this.getSampleValues();
        int i = 0;
        while (i < keys.length) {
            try {
                m.put(keys[i], values[i]);
            }
            catch (NullPointerException exception) {
                Assert.assertTrue((String)"NullPointerException only allowed to be thrown if either the key or value is null.", (keys[i] == null || values[i] == null ? 1 : 0) != 0);
                Assert.assertTrue((String)"NullPointerException on null key, but isAllowNullKey is not overridden to return false.", (keys[i] == null || !this.isAllowNullKey() ? 1 : 0) != 0);
                Assert.assertTrue((String)"NullPointerException on null value, but isAllowNullValue is not overridden to return false.", (values[i] == null || !this.isAllowNullValue() ? 1 : 0) != 0);
                Assert.assertTrue((String)"Unknown reason for NullPointer.", (boolean)false);
            }
            ++i;
        }
        Assert.assertEquals((String)"size must reflect number of mappings added.", (int)keys.length, (int)m.size());
    }

    public abstract Map makeEmptyMap();

    public Map makeFullMap() {
        Map m = this.makeEmptyMap();
        this.addSampleMappings(m);
        return m;
    }

    public Object makeObject() {
        return this.makeEmptyMap();
    }

    public Map makeConfirmedMap() {
        return new HashMap();
    }

    public Map.Entry cloneMapEntry(Map.Entry entry) {
        HashMap map = new HashMap();
        map.put(entry.getKey(), entry.getValue());
        return map.entrySet().iterator().next();
    }

    public String getCompatibilityVersion() {
        return super.getCompatibilityVersion();
    }

    public void testSampleMappings() {
        Object[] keys = this.getSampleKeys();
        Object[] values = this.getSampleValues();
        Object[] newValues = this.getNewSampleValues();
        Assert.assertTrue((String)"failure in test: Must have keys returned from getSampleKeys.", (keys != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"failure in test: Must have values returned from getSampleValues.", (values != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"failure in test: not the same number of sample keys and values.", (int)keys.length, (int)values.length);
        Assert.assertEquals((String)"failure in test: not the same number of values and new values.", (int)values.length, (int)newValues.length);
        int i = 0;
        while (i < keys.length - 1) {
            int j = i + 1;
            while (j < keys.length) {
                Assert.assertTrue((String)"failure in test: duplicate null keys.", (keys[i] != null || keys[j] != null ? 1 : 0) != 0);
                Assert.assertTrue((String)"failure in test: duplicate non-null key.", (keys[i] == null || keys[j] == null || !keys[i].equals(keys[j]) && !keys[j].equals(keys[i]) ? 1 : 0) != 0);
                ++j;
            }
            Assert.assertTrue((String)"failure in test: found null key, but isNullKeySupported is false.", (keys[i] != null || this.isAllowNullKey() ? 1 : 0) != 0);
            Assert.assertTrue((String)"failure in test: found null value, but isNullValueSupported is false.", (values[i] != null || this.isAllowNullValue() ? 1 : 0) != 0);
            Assert.assertTrue((String)"failure in test: found null new value, but isNullValueSupported is false.", (newValues[i] != null || this.isAllowNullValue() ? 1 : 0) != 0);
            Assert.assertTrue((String)"failure in test: values should not be the same as new value", (values[i] != newValues[i] && (values[i] == null || !values[i].equals(newValues[i])) ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testMakeMap() {
        Map em = this.makeEmptyMap();
        Assert.assertTrue((String)"failure in test: makeEmptyMap must return a non-null map.", (em != null ? 1 : 0) != 0);
        Map em2 = this.makeEmptyMap();
        Assert.assertTrue((String)"failure in test: makeEmptyMap must return a non-null map.", (em != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"failure in test: makeEmptyMap must return a new map with each invocation.", (em != em2 ? 1 : 0) != 0);
        Map fm = this.makeFullMap();
        Assert.assertTrue((String)"failure in test: makeFullMap must return a non-null map.", (fm != null ? 1 : 0) != 0);
        Map fm2 = this.makeFullMap();
        Assert.assertTrue((String)"failure in test: makeFullMap must return a non-null map.", (fm != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"failure in test: makeFullMap must return a new map with each invocation.", (fm != fm2 ? 1 : 0) != 0);
    }

    public void testMapIsEmpty() {
        this.resetEmpty();
        Assert.assertEquals((String)"Map.isEmpty() should return true with an empty map", (boolean)true, (boolean)this.map.isEmpty());
        this.verify();
        this.resetFull();
        Assert.assertEquals((String)"Map.isEmpty() should return false with a non-empty map", (boolean)false, (boolean)this.map.isEmpty());
        this.verify();
    }

    public void testMapSize() {
        this.resetEmpty();
        Assert.assertEquals((String)"Map.size() should be 0 with an empty map", (int)0, (int)this.map.size());
        this.verify();
        this.resetFull();
        Assert.assertEquals((String)"Map.size() should equal the number of entries in the map", (int)this.getSampleKeys().length, (int)this.map.size());
        this.verify();
    }

    public void testMapClear() {
        if (!this.isRemoveSupported()) {
            try {
                this.resetFull();
                this.map.clear();
                Assert.fail((String)"Expected UnsupportedOperationException on clear");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
        this.resetEmpty();
        this.map.clear();
        this.confirmed.clear();
        this.verify();
        this.resetFull();
        this.map.clear();
        this.confirmed.clear();
        this.verify();
    }

    public void testMapContainsKey() {
        Object[] keys = this.getSampleKeys();
        this.resetEmpty();
        int i = 0;
        while (i < keys.length) {
            Assert.assertTrue((String)"Map must not contain key when map is empty", (!this.map.containsKey(keys[i]) ? 1 : 0) != 0);
            ++i;
        }
        this.verify();
        this.resetFull();
        int i2 = 0;
        while (i2 < keys.length) {
            Assert.assertTrue((String)("Map must contain key for a mapping in the map. Missing: " + keys[i2]), (boolean)this.map.containsKey(keys[i2]));
            ++i2;
        }
        this.verify();
    }

    public void testMapContainsValue() {
        Object[] values = this.getSampleValues();
        this.resetEmpty();
        int i = 0;
        while (i < values.length) {
            Assert.assertTrue((String)"Empty map must not contain value", (!this.map.containsValue(values[i]) ? 1 : 0) != 0);
            ++i;
        }
        this.verify();
        this.resetFull();
        int i2 = 0;
        while (i2 < values.length) {
            Assert.assertTrue((String)"Map must contain value for a mapping in the map.", (boolean)this.map.containsValue(values[i2]));
            ++i2;
        }
        this.verify();
    }

    public void testMapEquals() {
        this.resetEmpty();
        Assert.assertTrue((String)"Empty maps unequal.", (boolean)this.map.equals(this.confirmed));
        this.verify();
        this.resetFull();
        Assert.assertTrue((String)"Full maps unequal.", (boolean)this.map.equals(this.confirmed));
        this.verify();
        this.resetFull();
        Iterator iter = this.confirmed.keySet().iterator();
        iter.next();
        iter.remove();
        Assert.assertTrue((String)"Different maps equal.", (!this.map.equals(this.confirmed) ? 1 : 0) != 0);
        this.resetFull();
        Assert.assertTrue((String)"equals(null) returned true.", (!this.map.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals(new Object()) returned true.", (!this.map.equals(new Object()) ? 1 : 0) != 0);
        this.verify();
    }

    public void testMapGet() {
        this.resetEmpty();
        Object[] keys = this.getSampleKeys();
        Object[] values = this.getSampleValues();
        int i = 0;
        while (i < keys.length) {
            Assert.assertTrue((String)"Empty map.get() should return null.", (this.map.get(keys[i]) == null ? 1 : 0) != 0);
            ++i;
        }
        this.verify();
        this.resetFull();
        int i2 = 0;
        while (i2 < keys.length) {
            Assert.assertEquals((String)"Full map.get() should return value from mapping.", (Object)values[i2], this.map.get(keys[i2]));
            ++i2;
        }
    }

    public void testMapHashCode() {
        this.resetEmpty();
        Assert.assertTrue((String)"Empty maps have different hashCodes.", (this.map.hashCode() == this.confirmed.hashCode() ? 1 : 0) != 0);
        this.resetFull();
        Assert.assertTrue((String)"Equal maps have different hashCodes.", (this.map.hashCode() == this.confirmed.hashCode() ? 1 : 0) != 0);
    }

    public void testMapToString() {
        this.resetEmpty();
        Assert.assertTrue((String)"Empty map toString() should not return null", (this.map.toString() != null ? 1 : 0) != 0);
        this.verify();
        this.resetFull();
        Assert.assertTrue((String)"Empty map toString() should not return null", (this.map.toString() != null ? 1 : 0) != 0);
        this.verify();
    }

    public void testEmptyMapCompatibility() throws Exception {
        Map map = this.makeEmptyMap();
        if (map instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Map map2 = (Map)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(map));
            Assert.assertEquals((String)"Map is empty", (int)0, (int)map2.size());
        }
    }

    public void testFullMapCompatibility() throws Exception {
        Map map = this.makeFullMap();
        if (map instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Map map2 = (Map)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(map));
            Assert.assertEquals((String)"Map is the right size", (int)this.getSampleKeys().length, (int)map2.size());
        }
    }

    public void testMapPut() {
        this.resetEmpty();
        Object[] keys = this.getSampleKeys();
        Object[] values = this.getSampleValues();
        Object[] newValues = this.getNewSampleValues();
        if (this.isPutAddSupported()) {
            int i = 0;
            while (i < keys.length) {
                Object o = this.map.put(keys[i], values[i]);
                this.confirmed.put(keys[i], values[i]);
                this.verify();
                Assert.assertTrue((String)"First map.put should return null", (o == null ? 1 : 0) != 0);
                Assert.assertTrue((String)"Map should contain key after put", (boolean)this.map.containsKey(keys[i]));
                Assert.assertTrue((String)"Map should contain value after put", (boolean)this.map.containsValue(values[i]));
                ++i;
            }
            if (this.isPutChangeSupported()) {
                int i2 = 0;
                while (i2 < keys.length) {
                    Object o = this.map.put(keys[i2], newValues[i2]);
                    this.confirmed.put(keys[i2], newValues[i2]);
                    this.verify();
                    Assert.assertEquals((String)"Map.put should return previous value when changed", (Object)values[i2], (Object)o);
                    Assert.assertTrue((String)"Map should still contain key after put when changed", (boolean)this.map.containsKey(keys[i2]));
                    Assert.assertTrue((String)"Map should contain new value after put when changed", (boolean)this.map.containsValue(newValues[i2]));
                    if (!this.isAllowDuplicateValues()) {
                        Assert.assertTrue((String)"Map should not contain old value after put when changed", (!this.map.containsValue(values[i2]) ? 1 : 0) != 0);
                    }
                    ++i2;
                }
            } else {
                try {
                    this.map.put(keys[0], newValues[0]);
                    Assert.fail((String)"Expected IllegalArgumentException or UnsupportedOperationException on put (change)");
                }
                catch (IllegalArgumentException ex) {
                }
                catch (UnsupportedOperationException ex) {}
            }
        } else if (this.isPutChangeSupported()) {
            this.resetEmpty();
            try {
                this.map.put(keys[0], values[0]);
                Assert.fail((String)"Expected UnsupportedOperationException or IllegalArgumentException on put (add) when fixed size");
            }
            catch (IllegalArgumentException ex) {
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            this.resetFull();
            int i = 0;
            Iterator it = this.map.keySet().iterator();
            while (it.hasNext() && i < newValues.length) {
                Object key = it.next();
                Object o = this.map.put(key, newValues[i]);
                Object value = this.confirmed.put(key, newValues[i]);
                this.verify();
                Assert.assertEquals((String)"Map.put should return previous value when changed", (Object)value, (Object)o);
                Assert.assertTrue((String)"Map should still contain key after put when changed", (boolean)this.map.containsKey(key));
                Assert.assertTrue((String)"Map should contain new value after put when changed", (boolean)this.map.containsValue(newValues[i]));
                if (!this.isAllowDuplicateValues()) {
                    Assert.assertTrue((String)"Map should not contain old value after put when changed", (!this.map.containsValue(values[i]) ? 1 : 0) != 0);
                }
                ++i;
            }
        } else {
            try {
                this.map.put(keys[0], values[0]);
                Assert.fail((String)"Expected UnsupportedOperationException on put (add)");
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
        }
    }

    public void testMapPutNullKey() {
        this.resetFull();
        Object[] values = this.getSampleValues();
        if (this.isPutAddSupported()) {
            if (this.isAllowNullKey()) {
                this.map.put(null, values[0]);
            } else {
                try {
                    this.map.put(null, values[0]);
                    Assert.fail((String)"put(null, value) should throw NPE/IAE");
                }
                catch (NullPointerException ex) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public void testMapPutNullValue() {
        this.resetFull();
        Object[] keys = this.getSampleKeys();
        if (this.isPutAddSupported()) {
            if (this.isAllowNullValue()) {
                this.map.put(keys[0], null);
            } else {
                try {
                    this.map.put(keys[0], null);
                    Assert.fail((String)"put(key, null) should throw NPE/IAE");
                }
                catch (NullPointerException ex) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public void testMapPutAll() {
        if (!this.isPutAddSupported()) {
            if (!this.isPutChangeSupported()) {
                Map temp = this.makeFullMap();
                this.resetEmpty();
                try {
                    this.map.putAll(temp);
                    Assert.fail((String)"Expected UnsupportedOperationException on putAll");
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
            }
            return;
        }
        this.resetEmpty();
        Assert.assertEquals((int)0, (int)this.map.size());
        this.map.putAll(new HashMap());
        Assert.assertEquals((int)0, (int)this.map.size());
        this.resetFull();
        int size = this.map.size();
        this.map.putAll(new HashMap());
        Assert.assertEquals((int)size, (int)this.map.size());
        this.resetEmpty();
        Map m2 = this.makeFullMap();
        this.map.putAll(m2);
        this.confirmed.putAll(m2);
        this.verify();
        this.resetEmpty();
        m2 = this.makeConfirmedMap();
        Object[] keys = this.getSampleKeys();
        Object[] values = this.getSampleValues();
        int i = 0;
        while (i < keys.length) {
            m2.put(keys[i], values[i]);
            ++i;
        }
        this.map.putAll(m2);
        this.confirmed.putAll(m2);
        this.verify();
        this.resetEmpty();
        m2 = this.makeConfirmedMap();
        this.map.put(keys[0], values[0]);
        this.confirmed.put(keys[0], values[0]);
        this.verify();
        int i2 = 1;
        while (i2 < keys.length) {
            m2.put(keys[i2], values[i2]);
            ++i2;
        }
        this.map.putAll(m2);
        this.confirmed.putAll(m2);
        this.verify();
    }

    public void testMapRemove() {
        if (!this.isRemoveSupported()) {
            try {
                this.resetFull();
                this.map.remove(this.map.keySet().iterator().next());
                Assert.fail((String)"Expected UnsupportedOperationException on remove");
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        this.resetEmpty();
        Object[] keys = this.getSampleKeys();
        Object[] values = this.getSampleValues();
        int i = 0;
        while (i < keys.length) {
            Object o = this.map.remove(keys[i]);
            Assert.assertTrue((String)"First map.remove should return null", (o == null ? 1 : 0) != 0);
            ++i;
        }
        this.verify();
        this.resetFull();
        int i2 = 0;
        while (i2 < keys.length) {
            Object o = this.map.remove(keys[i2]);
            this.confirmed.remove(keys[i2]);
            this.verify();
            Assert.assertEquals((String)"map.remove with valid key should return value", (Object)values[i2], o);
            ++i2;
        }
        Object[] other = this.getOtherKeys();
        this.resetFull();
        int size = this.map.size();
        int i3 = 0;
        while (i3 < other.length) {
            Object o = this.map.remove(other[i3]);
            Assert.assertEquals((String)"map.remove for nonexistent key should return null", o, null);
            Assert.assertEquals((String)"map.remove for nonexistent key should not shrink map", (int)size, (int)this.map.size());
            ++i3;
        }
        this.verify();
    }

    public void testValuesClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Collection values = this.map.values();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((values.size() > 0 ? 1 : 0) != 0);
        values.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((values.size() == 0 ? 1 : 0) != 0);
        this.resetFull();
        values = this.map.values();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((values.size() > 0 ? 1 : 0) != 0);
        this.map.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((values.size() == 0 ? 1 : 0) != 0);
    }

    public void testKeySetClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Set keySet = this.map.keySet();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((keySet.size() > 0 ? 1 : 0) != 0);
        keySet.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((keySet.size() == 0 ? 1 : 0) != 0);
        this.resetFull();
        keySet = this.map.keySet();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((keySet.size() > 0 ? 1 : 0) != 0);
        this.map.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((keySet.size() == 0 ? 1 : 0) != 0);
    }

    public void testEntrySetClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Set entrySet = this.map.entrySet();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((entrySet.size() > 0 ? 1 : 0) != 0);
        entrySet.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((entrySet.size() == 0 ? 1 : 0) != 0);
        this.resetFull();
        entrySet = this.map.entrySet();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((entrySet.size() > 0 ? 1 : 0) != 0);
        this.map.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((entrySet.size() == 0 ? 1 : 0) != 0);
    }

    public void testEntrySetContains1() {
        this.resetFull();
        Set entrySet = this.map.entrySet();
        Map.Entry entry = entrySet.iterator().next();
        Assert.assertEquals((boolean)true, (boolean)entrySet.contains(entry));
    }

    public void testEntrySetContains2() {
        this.resetFull();
        Set entrySet = this.map.entrySet();
        Map.Entry entry = entrySet.iterator().next();
        Map.Entry test = this.cloneMapEntry(entry);
        Assert.assertEquals((boolean)true, (boolean)entrySet.contains(test));
    }

    public void testEntrySetContains3() {
        this.resetFull();
        Set entrySet = this.map.entrySet();
        Map.Entry entry = entrySet.iterator().next();
        HashMap temp = new HashMap();
        temp.put(entry.getKey(), "A VERY DIFFERENT VALUE");
        Map.Entry test = temp.entrySet().iterator().next();
        Assert.assertEquals((boolean)false, (boolean)entrySet.contains(test));
    }

    public void testEntrySetRemove1() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.map.size();
        Set entrySet = this.map.entrySet();
        Map.Entry entry = entrySet.iterator().next();
        Object key = entry.getKey();
        Assert.assertEquals((boolean)true, (boolean)entrySet.remove(entry));
        Assert.assertEquals((boolean)false, (boolean)this.map.containsKey(key));
        Assert.assertEquals((int)(size - 1), (int)this.map.size());
    }

    public void testEntrySetRemove2() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.map.size();
        Set entrySet = this.map.entrySet();
        Map.Entry entry = entrySet.iterator().next();
        Object key = entry.getKey();
        Map.Entry test = this.cloneMapEntry(entry);
        Assert.assertEquals((boolean)true, (boolean)entrySet.remove(test));
        Assert.assertEquals((boolean)false, (boolean)this.map.containsKey(key));
        Assert.assertEquals((int)(size - 1), (int)this.map.size());
    }

    public void testEntrySetRemove3() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int size = this.map.size();
        Set entrySet = this.map.entrySet();
        Map.Entry entry = entrySet.iterator().next();
        Object key = entry.getKey();
        HashMap temp = new HashMap();
        temp.put(entry.getKey(), "A VERY DIFFERENT VALUE");
        Map.Entry test = temp.entrySet().iterator().next();
        Assert.assertEquals((boolean)false, (boolean)entrySet.remove(test));
        Assert.assertEquals((boolean)true, (boolean)this.map.containsKey(key));
        Assert.assertEquals((int)size, (int)this.map.size());
    }

    public void testValuesRemoveChangesMap() {
        this.resetFull();
        Object[] sampleValues = this.getSampleValues();
        Collection values = this.map.values();
        int i = 0;
        while (i < sampleValues.length) {
            if (this.map.containsValue(sampleValues[i])) {
                int j = 0;
                while (values.contains(sampleValues[i]) && j < 10000) {
                    try {
                        values.remove(sampleValues[i]);
                    }
                    catch (UnsupportedOperationException e) {
                        return;
                    }
                    ++j;
                }
                Assert.assertTrue((String)"values().remove(obj) is broken", (j < 10000 ? 1 : 0) != 0);
                Assert.assertTrue((String)"Value should have been removed from the underlying map.", (!this.map.containsValue(sampleValues[i]) ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testKeySetRemoveChangesMap() {
        this.resetFull();
        Object[] sampleKeys = this.getSampleKeys();
        Set keys = this.map.keySet();
        int i = 0;
        while (i < sampleKeys.length) {
            try {
                keys.remove(sampleKeys[i]);
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            Assert.assertTrue((String)"Key should have been removed from the underlying map.", (!this.map.containsKey(sampleKeys[i]) ? 1 : 0) != 0);
            ++i;
        }
    }

    private Map.Entry[] makeEntryArray(Object[] keys, Object[] values) {
        Map.Entry[] result = new Map.Entry[keys.length];
        int i = 0;
        while (i < keys.length) {
            Map map = this.makeConfirmedMap();
            map.put(keys[i], values[i]);
            result[i] = map.entrySet().iterator().next();
            ++i;
        }
        return result;
    }

    public BulkTest bulkTestMapEntrySet() {
        return new TestMapEntrySet();
    }

    public BulkTest bulkTestMapKeySet() {
        return new TestMapKeySet();
    }

    public BulkTest bulkTestMapValues() {
        return new TestMapValues();
    }

    public void resetEmpty() {
        this.map = this.makeEmptyMap();
        this.views();
        this.confirmed = this.makeConfirmedMap();
    }

    public void resetFull() {
        this.map = this.makeFullMap();
        this.views();
        this.confirmed = this.makeConfirmedMap();
        Object[] k = this.getSampleKeys();
        Object[] v = this.getSampleValues();
        int i = 0;
        while (i < k.length) {
            this.confirmed.put(k[i], v[i]);
            ++i;
        }
    }

    private void views() {
        this.keySet = this.map.keySet();
        this.values = this.map.values();
        this.entrySet = this.map.entrySet();
    }

    public void verify() {
        this.verifyMap();
        this.verifyEntrySet();
        this.verifyKeySet();
        this.verifyValues();
    }

    public void verifyMap() {
        int size = this.confirmed.size();
        boolean empty = this.confirmed.isEmpty();
        Assert.assertEquals((String)"Map should be same size as HashMap", (int)size, (int)this.map.size());
        Assert.assertEquals((String)"Map should be empty if HashMap is", (boolean)empty, (boolean)this.map.isEmpty());
        Assert.assertEquals((String)"hashCodes should be the same", (int)this.confirmed.hashCode(), (int)this.map.hashCode());
        Assert.assertTrue((String)"Map should still equal HashMap", (boolean)this.map.equals(this.confirmed));
    }

    public void verifyEntrySet() {
        int size = this.confirmed.size();
        boolean empty = this.confirmed.isEmpty();
        Assert.assertEquals((String)("entrySet should be same size as HashMap's\nTest: " + this.entrySet + "\nReal: " + this.confirmed.entrySet()), (int)size, (int)this.entrySet.size());
        Assert.assertEquals((String)("entrySet should be empty if HashMap is\nTest: " + this.entrySet + "\nReal: " + this.confirmed.entrySet()), (boolean)empty, (boolean)this.entrySet.isEmpty());
        Assert.assertTrue((String)("entrySet should contain all HashMap's elements\nTest: " + this.entrySet + "\nReal: " + this.confirmed.entrySet()), (boolean)this.entrySet.containsAll(this.confirmed.entrySet()));
        Assert.assertEquals((String)("entrySet hashCodes should be the same\nTest: " + this.entrySet + "\nReal: " + this.confirmed.entrySet()), (int)this.confirmed.entrySet().hashCode(), (int)this.entrySet.hashCode());
        Assert.assertEquals((String)"Map's entry set should still equal HashMap's", this.confirmed.entrySet(), (Object)this.entrySet);
    }

    public void verifyKeySet() {
        int size = this.confirmed.size();
        boolean empty = this.confirmed.isEmpty();
        Assert.assertEquals((String)("keySet should be same size as HashMap's\nTest: " + this.keySet + "\nReal: " + this.confirmed.keySet()), (int)size, (int)this.keySet.size());
        Assert.assertEquals((String)("keySet should be empty if HashMap is\nTest: " + this.keySet + "\nReal: " + this.confirmed.keySet()), (boolean)empty, (boolean)this.keySet.isEmpty());
        Assert.assertTrue((String)("keySet should contain all HashMap's elements\nTest: " + this.keySet + "\nReal: " + this.confirmed.keySet()), (boolean)this.keySet.containsAll(this.confirmed.keySet()));
        Assert.assertEquals((String)("keySet hashCodes should be the same\nTest: " + this.keySet + "\nReal: " + this.confirmed.keySet()), (int)this.confirmed.keySet().hashCode(), (int)this.keySet.hashCode());
        Assert.assertEquals((String)"Map's key set should still equal HashMap's", this.confirmed.keySet(), (Object)this.keySet);
    }

    public void verifyValues() {
        ArrayList known = new ArrayList(this.confirmed.values());
        ArrayList test = new ArrayList(this.values);
        int size = this.confirmed.size();
        boolean empty = this.confirmed.isEmpty();
        Assert.assertEquals((String)("values should be same size as HashMap's\nTest: " + test + "\nReal: " + known), (int)size, (int)this.values.size());
        Assert.assertEquals((String)("values should be empty if HashMap is\nTest: " + test + "\nReal: " + known), (boolean)empty, (boolean)this.values.isEmpty());
        Assert.assertTrue((String)("values should contain all HashMap's elements\nTest: " + test + "\nReal: " + known), (boolean)test.containsAll(known));
        Assert.assertTrue((String)("values should contain all HashMap's elements\nTest: " + test + "\nReal: " + known), (boolean)known.containsAll(test));
        Iterator it = known.iterator();
        while (it.hasNext()) {
            boolean removed = test.remove(it.next());
            Assert.assertTrue((String)"Map's values should still equal HashMap's", (boolean)removed);
        }
        Assert.assertTrue((String)"Map's values should still equal HashMap's", (boolean)test.isEmpty());
    }

    public void tearDown() throws Exception {
        this.map = null;
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.confirmed = null;
    }

    static {
        String str = System.getProperty("java.version");
        JDK12 = str.startsWith("1.2");
    }

    public class TestMapValues
    extends AbstractTestCollection {
        public TestMapValues() {
            super("");
        }

        public Object[] getFullElements() {
            return AbstractTestMap.this.getSampleValues();
        }

        public Object[] getOtherElements() {
            return AbstractTestMap.this.getOtherValues();
        }

        public Collection makeCollection() {
            return AbstractTestMap.this.makeEmptyMap().values();
        }

        public Collection makeFullCollection() {
            return AbstractTestMap.this.makeFullMap().values();
        }

        public boolean isNullSupported() {
            return AbstractTestMap.this.isAllowNullKey();
        }

        public boolean isAddSupported() {
            return false;
        }

        public boolean isRemoveSupported() {
            return AbstractTestMap.this.isRemoveSupported();
        }

        public boolean isTestSerialization() {
            return false;
        }

        public boolean areEqualElementsDistinguishable() {
            return true;
        }

        public Collection makeConfirmedCollection() {
            return null;
        }

        public Collection makeConfirmedFullCollection() {
            return null;
        }

        public void resetFull() {
            AbstractTestMap.this.resetFull();
            this.collection = AbstractTestMap.this.map.values();
            this.confirmed = AbstractTestMap.this.confirmed.values();
        }

        public void resetEmpty() {
            AbstractTestMap.this.resetEmpty();
            this.collection = AbstractTestMap.this.map.values();
            this.confirmed = AbstractTestMap.this.confirmed.values();
        }

        public void verify() {
            super.verify();
            AbstractTestMap.this.verify();
        }
    }

    public class TestMapKeySet
    extends AbstractTestSet {
        public TestMapKeySet() {
            super("");
        }

        public Object[] getFullElements() {
            return AbstractTestMap.this.getSampleKeys();
        }

        public Object[] getOtherElements() {
            return AbstractTestMap.this.getOtherKeys();
        }

        public Set makeEmptySet() {
            return AbstractTestMap.this.makeEmptyMap().keySet();
        }

        public Set makeFullSet() {
            return AbstractTestMap.this.makeFullMap().keySet();
        }

        public boolean isNullSupported() {
            return AbstractTestMap.this.isAllowNullKey();
        }

        public boolean isAddSupported() {
            return false;
        }

        public boolean isRemoveSupported() {
            return AbstractTestMap.this.isRemoveSupported();
        }

        public boolean isTestSerialization() {
            return false;
        }

        public void resetEmpty() {
            AbstractTestMap.this.resetEmpty();
            this.collection = AbstractTestMap.this.map.keySet();
            this.confirmed = AbstractTestMap.this.confirmed.keySet();
        }

        public void resetFull() {
            AbstractTestMap.this.resetFull();
            this.collection = AbstractTestMap.this.map.keySet();
            this.confirmed = AbstractTestMap.this.confirmed.keySet();
        }

        public void verify() {
            super.verify();
            AbstractTestMap.this.verify();
        }
    }

    public class TestMapEntrySet
    extends AbstractTestSet {
        public TestMapEntrySet() {
            super("MapEntrySet");
        }

        public Object[] getFullElements() {
            Object[] k = AbstractTestMap.this.getSampleKeys();
            Object[] v = AbstractTestMap.this.getSampleValues();
            return AbstractTestMap.this.makeEntryArray(k, v);
        }

        public Object[] getOtherElements() {
            Object[] k = AbstractTestMap.this.getOtherKeys();
            Object[] v = AbstractTestMap.this.getOtherValues();
            return AbstractTestMap.this.makeEntryArray(k, v);
        }

        public Set makeEmptySet() {
            return AbstractTestMap.this.makeEmptyMap().entrySet();
        }

        public Set makeFullSet() {
            return AbstractTestMap.this.makeFullMap().entrySet();
        }

        public boolean isAddSupported() {
            return false;
        }

        public boolean isRemoveSupported() {
            return AbstractTestMap.this.isRemoveSupported();
        }

        public boolean isGetStructuralModify() {
            return AbstractTestMap.this.isGetStructuralModify();
        }

        public boolean isTestSerialization() {
            return false;
        }

        public void resetFull() {
            AbstractTestMap.this.resetFull();
            this.collection = AbstractTestMap.this.map.entrySet();
            this.confirmed = AbstractTestMap.this.confirmed.entrySet();
        }

        public void resetEmpty() {
            AbstractTestMap.this.resetEmpty();
            this.collection = AbstractTestMap.this.map.entrySet();
            this.confirmed = AbstractTestMap.this.confirmed.entrySet();
        }

        public void testMapEntrySetIteratorEntry() {
            this.resetFull();
            Iterator it = this.collection.iterator();
            int count = 0;
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                Assert.assertEquals((boolean)true, (boolean)AbstractTestMap.this.map.containsKey(entry.getKey()));
                Assert.assertEquals((boolean)true, (boolean)AbstractTestMap.this.map.containsValue(entry.getValue()));
                if (!this.isGetStructuralModify()) {
                    Assert.assertEquals(AbstractTestMap.this.map.get(entry.getKey()), entry.getValue());
                }
                ++count;
            }
            Assert.assertEquals((int)this.collection.size(), (int)count);
        }

        public void testMapEntrySetIteratorEntrySetValue() {
            Object key1 = AbstractTestMap.this.getSampleKeys()[0];
            Object key2 = AbstractTestMap.this.getSampleKeys().length == 1 ? AbstractTestMap.this.getSampleKeys()[0] : AbstractTestMap.this.getSampleKeys()[1];
            Object newValue1 = AbstractTestMap.this.getNewSampleValues()[0];
            Object newValue2 = AbstractTestMap.this.getNewSampleValues().length == 1 ? AbstractTestMap.this.getNewSampleValues()[0] : AbstractTestMap.this.getNewSampleValues()[1];
            this.resetFull();
            Iterator it = this.collection.iterator();
            Map.Entry entry1 = this.getEntry(it, key1);
            it = this.collection.iterator();
            Map.Entry entry2 = this.getEntry(it, key2);
            Iterator itConfirmed = this.confirmed.iterator();
            Map.Entry entryConfirmed1 = this.getEntry(itConfirmed, key1);
            itConfirmed = this.confirmed.iterator();
            Map.Entry entryConfirmed2 = this.getEntry(itConfirmed, key2);
            this.verify();
            if (!AbstractTestMap.this.isSetValueSupported()) {
                try {
                    entry1.setValue(newValue1);
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
                return;
            }
            entry1.setValue(newValue1);
            entryConfirmed1.setValue(newValue1);
            Assert.assertEquals((Object)newValue1, entry1.getValue());
            Assert.assertEquals((boolean)true, (boolean)AbstractTestMap.this.map.containsKey(entry1.getKey()));
            Assert.assertEquals((boolean)true, (boolean)AbstractTestMap.this.map.containsValue(newValue1));
            Assert.assertEquals((Object)newValue1, AbstractTestMap.this.map.get(entry1.getKey()));
            this.verify();
            entry1.setValue(newValue1);
            entryConfirmed1.setValue(newValue1);
            Assert.assertEquals((Object)newValue1, entry1.getValue());
            Assert.assertEquals((boolean)true, (boolean)AbstractTestMap.this.map.containsKey(entry1.getKey()));
            Assert.assertEquals((boolean)true, (boolean)AbstractTestMap.this.map.containsValue(newValue1));
            Assert.assertEquals((Object)newValue1, AbstractTestMap.this.map.get(entry1.getKey()));
            this.verify();
            entry2.setValue(newValue2);
            entryConfirmed2.setValue(newValue2);
            Assert.assertEquals((Object)newValue2, entry2.getValue());
            Assert.assertEquals((boolean)true, (boolean)AbstractTestMap.this.map.containsKey(entry2.getKey()));
            Assert.assertEquals((boolean)true, (boolean)AbstractTestMap.this.map.containsValue(newValue2));
            Assert.assertEquals((Object)newValue2, AbstractTestMap.this.map.get(entry2.getKey()));
            this.verify();
        }

        public Map.Entry getEntry(Iterator itConfirmed, Object key) {
            Map.Entry entry = null;
            while (itConfirmed.hasNext()) {
                Map.Entry temp = (Map.Entry)itConfirmed.next();
                if (temp.getKey() == null) {
                    if (key != null) continue;
                    entry = temp;
                    break;
                }
                if (!temp.getKey().equals(key)) continue;
                entry = temp;
                break;
            }
            Assert.assertNotNull((String)("No matching entry in map for key '" + key + "'"), (Object)entry);
            return entry;
        }

        public void testMapEntrySetRemoveNonMapEntry() {
            if (!this.isRemoveSupported()) {
                return;
            }
            this.resetFull();
            Assert.assertEquals((boolean)false, (boolean)this.getSet().remove(null));
            Assert.assertEquals((boolean)false, (boolean)this.getSet().remove(new Object()));
        }

        public void verify() {
            super.verify();
            AbstractTestMap.this.verify();
        }
    }
}

