/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.filters;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.filters.EfficientFilter;
import edu.uci.ics.jung.graph.filters.Filter;
import edu.uci.ics.jung.graph.filters.UnassembledGraph;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class GeneralEdgeAcceptFilter
implements Filter {
    public abstract boolean acceptEdge(Edge var1);

    public UnassembledGraph filter(Graph g) {
        Set vertices = g.getVertices();
        Set edges = g.getEdges();
        Set newEdges = this.chooseGoodEdges(edges);
        return new UnassembledGraph((Filter)this, vertices, newEdges, g);
    }

    public UnassembledGraph filter(UnassembledGraph ug) {
        if (!(this instanceof EfficientFilter)) {
            throw new FatalException("Do not call non-efficient filters with UnassembledGraphs.");
        }
        Set vertices = null;
        Set edges = null;
        vertices = ug.getUntouchedVertices();
        edges = ug.getUntouchedEdges();
        if (vertices == null) {
            vertices = ug.getOriginalGraph().getVertices();
        }
        if (edges == null) {
            edges = ug.getOriginalGraph().getEdges();
        }
        Set newEdges = this.chooseGoodEdges(edges);
        return new UnassembledGraph((Filter)this, vertices, newEdges, ug);
    }

    private Set chooseGoodEdges(Set edges) {
        HashSet<Edge> newEdges = new HashSet<Edge>();
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            if (!this.acceptEdge(e)) continue;
            newEdges.add(e);
        }
        return newEdges;
    }
}

