/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.graph.impl.SimpleDirectedSparseVertex;
import edu.uci.ics.jung.graph.impl.SimpleSparseVertex;
import edu.uci.ics.jung.graph.impl.SimpleUndirectedSparseVertex;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseVertex;
import edu.uci.ics.jung.utils.VertexGenerator;
import java.util.Collection;

public class TypedVertexGenerator
implements VertexGenerator {
    protected Object type;
    protected boolean simple;
    protected static final Object UNDIRECTED = "UNDIRECTED";
    protected static final Object DIRECTED = "DIRECTED";
    protected static final Object MIXED = "MIXED";

    public TypedVertexGenerator(Collection edge_requirements) {
        this.type = edge_requirements.contains(Graph.UNDIRECTED_EDGE) ? UNDIRECTED : (edge_requirements.contains(Graph.DIRECTED_EDGE) ? DIRECTED : MIXED);
        this.simple = edge_requirements.contains(Graph.NOT_PARALLEL_EDGE);
    }

    public TypedVertexGenerator(ArchetypeGraph g) {
        this(g.getEdgeConstraints());
    }

    public Vertex create() {
        if (this.type == UNDIRECTED) {
            if (this.simple) {
                return new SimpleUndirectedSparseVertex();
            }
            return new UndirectedSparseVertex();
        }
        if (this.type == DIRECTED) {
            if (this.simple) {
                return new SimpleDirectedSparseVertex();
            }
            return new DirectedSparseVertex();
        }
        if (this.type == MIXED) {
            if (this.simple) {
                return new SimpleSparseVertex();
            }
            return new SparseVertex();
        }
        throw new FatalException("Internal error: unrecognized vertex type");
    }
}

