/*
 * Decompiled with CFR 0.152.
 */
package samples.graph.southern;

import edu.uci.ics.jung.graph.KPartiteGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.predicates.UserDatumVertexPredicate;
import edu.uci.ics.jung.io.BipartiteGraphReader;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import samples.preview_new_graphdraw.VertexRenderer;
import samples.preview_new_graphdraw.VisVertex;

public class BipartiteVertexRenderer
implements VertexRenderer {
    private StringLabeller dates;
    private StringLabeller women;
    private KPartiteGraph bpg;
    private List hiddenList;

    public BipartiteVertexRenderer(KPartiteGraph bpg, StringLabeller women, StringLabeller dates) {
        this.bpg = bpg;
        this.women = women;
        this.dates = dates;
    }

    public BipartiteVertexRenderer(StringLabeller women, StringLabeller dates) {
        this.women = women;
        this.dates = dates;
    }

    public void renderVertex(Graphics g, VisVertex vc) {
        Vertex bpv = vc.getVertex();
        UserDatumVertexPredicate part = BipartiteGraphReader.PART_A;
        if (this.bpg != null) {
            part = BipartiteGraphReader.getPartition((Vertex)bpv.getEqualVertex(this.bpg));
        }
        boolean in_a = part == BipartiteGraphReader.PART_A;
        StringLabeller sl = in_a ? this.women : this.dates;
        String s = sl.getLabel((Vertex)bpv.getEqualVertex(this.bpg));
        g.setColor(in_a ? Color.RED : Color.BLUE);
        if (this.hiddenList != null && this.hiddenList.contains(s)) {
            int x = (int)vc.getX();
            int y = (int)vc.getY();
            g.drawLine(x - 4, y - 4, x + 4, y + 4);
            g.drawLine(x + 4, y - 4, x - 4, y + 4);
        } else {
            g.fillRect((int)vc.getX() - 4, (int)vc.getY() - 4, 8, 8);
        }
        g.setColor(Color.black);
        g.drawString(s, (int)vc.getX() - 4, (int)vc.getY() + 16);
    }

    public void setHiddenList(List list) {
        this.hiddenList = list;
    }
}

