/* KNND.cpp - File generated by Varun Chandola */
#include <iostream>
#include <fstream>
#include <vector>
#include <string>
#include <string.h>
#include <stdlib.h>
#include <algorithm>
#include <map>
#include <queue>
#include <math.h>
#include <time.h>

#include "tools.h"

using namespace std;
char *sim_filename = 0;
char *output_filename = 0;
int nn=10;

vector<vector<float> > pairwise;
#define usage(msg, args...) \
{\
  fprintf(stderr, msg, ##args);\
  fprintf(stderr, \
"Usage:\n\n" \
"./KNND -i sim_filename -o output_filename -k nearest_neighbors\n\n"); \
  exit(1); \
}

void parseArgs(int argc, char** argv){
  int argi;
  for(argi=1; argi<argc; argi++){
    if(strcmp(argv[argi],"-i")==0){
      if(++argi<argc) sim_filename=strdup(argv[argi]);
      else usage("-i requires similarity matrix file argument\n");
    } else if(strcmp(argv[argi],"-o")==0){
      if(++argi<argc) output_filename=strdup(argv[argi]);
      else usage("-o requires output file argument\n");
    } else if(strcmp(argv[argi],"-k")==0){
      if(++argi<argc) nn=atoi(argv[argi]);
      else usage("-k requires number of nearest neighbors argument\n");
    } else if(strcmp(argv[argi], "-h")==0 || strcmp(argv[argi], "-?")==0){
      usage("Usage:");
    }
    else
      usage("Invalid switch '%s'\n", argv[argi]);
  }
  if(!sim_filename) usage("No similarity matrix file specified\n");
  if(!output_filename)   usage("No output file specified\n");
}
bool compare_dist(float a, float b){return a > b;}

int main(int argc, char *argv[]){
  parseArgs(argc,argv);
  ifstream simin(sim_filename);
  if(simin.fail()) {cerr << "similarity matrix file does not exist "<<sim_filename<<"\n"; exit(0);}
  readSequences(pairwise,simin);
  simin.close();
  //find anomaly score for each test sequence - similarity with nn^{th} closest neighbor
  ofstream out;out.open(output_filename);
  for(unsigned int i = 0; i < pairwise.size();i++){
    //nth_element(pairwise[i].begin(),pairwise[i].begin()+nn,pairwise[i].end());
    sort(pairwise[i].begin(),pairwise[i].end(),compare_dist);
    out << pairwise[i][nn-1] << "\n";
  }
  out.close();
}
