function [truth,weight] = CATD(dataset,iti,alpha)

% ----------------------------------------------------------------------
% Function for calculating the CATD
% Author: Qi Li
% 
% Input:   dataset--the dataset to be calculated on
%                   1st col is id index for entity
%                   2rd col is claim
%                   3rd col is source index
%                  
%          iti--number of iteration
%          alpha--significant level
%
% Output:  truth--estimated truth for each entity
%          weight--estimated weight for each source
%           ini_truth--initial of truth
% ----------------------------------------------------------------------
% reorganize data so that entity IDs are ordered
if (~issorted(dataset(:,1)))
	dataset=sortrows(dataset,1);
end

% get basic structures of the dataset
[list_entry,entry_ia,entry_ic]=unique(dataset(:,1),'rows','first'); % for structure of entities
[list_source,~,source_ic]=unique(dataset(:,3)); % for structure of sources
nof=size(dataset,1); % number of fact
nos=max(list_source);% number of sources
noe=length(entry_ia);% number of entities
entry_ia(noe+1)=nof+1;%modify entry_ia s.t. we know the beginning and ending rows of each entity

%initialize weight
weight=1/nos*ones(nos,1);
weight_matrix=weight(source_ic);

%initial truth
% calculate the inital truth
for i=1:noe % for each entity, do:
    tempvalue=dataset(entry_ia(i):(entry_ia(i+1)-1),2); % get the chunk of the claims from all sources
    truth_median(i,:)=median(tempvalue); % get median
    standerror(i,:)=std(tempvalue); % get standard divination
    if standerror(i,:)==0
        standerror(i,:)=0.1;
    end
end
% update truth
truth=truth_median;
truth_matrix=truth((entry_ic),:); 
std_matrix=standerror(entry_ic);

% start iteration
ii=1;
while(ii<= iti)
    ii=ii+1;
    con_count=zeros(nos,1);
    score2=zeros(nos,1);
    
    % ----------------------------------------------------------------------
    %update weight
    for j=1:nof % for each fact
        score2(dataset(j,3)) = score2(dataset(j,3))+sum((dataset(j,2)-truth_matrix(j,:)).^2/std_matrix(j)); % update sum of distance for the corresponding source
        con_count(dataset(j,3)) = con_count(dataset(j,3))+1; % update count of claims for the corresponding source
    end
    % remove empty sources
    score2(con_count==0)=[];
    con_count(con_count==0)=[];
    
    for source_i=1:length(con_count) % for each source
        weight(source_i)=chi2inv(alpha,con_count(source_i))/(score2(source_i)+0.0001); % calculate weight
    end

    weight_matrix=weight(source_ic); 
	% ----------------------------------------------------------------------
    %update truth
    for i=1:noe % for each entity
        tempvalue=dataset(entry_ia(i):(entry_ia(i+1)-1),2); % get the chunk of data       
        tempweight=weight_matrix(entry_ia(i):(entry_ia(i+1)-1)); % get their corresponding source weights
        truth(i,:)=((tempvalue'*tempweight)/sum(tempweight)); % update truth
    end
	
    truth_matrix=truth((entry_ic),:);
	% ----------------------------------------------------------------------
end
% put truth with entity index
truth=[list_entry,truth];

% put weight with source index
weight=[list_source,weight];
