function W=weightall(pM,class)
%
%  weightall: estimate local weights of all the models  
%             
%  Input: 
%       pM-a matrix containing all the base models' outputs on the target set. 
%          Each column represent one model. You must place classification models
%           before clustering models.
%
%       class-the number of classes in the problem
%
%  Output:         
%
%       W-a matrix summarizing the group-example relationships. Each row
%         corresponds to an example whereas each column corresponds to a
%         group. If the example is contained in the group, the entry is 1,
%         otherwise it is 0.
%
%

[num,k]=size(pM);

%for efficiency reason, precompute the local consistency measure for every
%pair of group nodes based on Eq. 5
gW=zeros(k*class,k*class);
    for h=1:k*class
        M1=floor((h-1)/class)+1;
        C1=mod((h-1),class)+1;
        id1=find(pM(:,M1)==C1);
        for l=h+1:k*class
            M2=floor((l-1)/class)+1;
            C2=mod((l-1),class)+1;
            id2=find(pM(:,M2)==C2);
            gW(h,l)=(length(intersect(id1,id2))-1)/(length(union(id1,id2))-1);
            gW(l,h)=gW(h,l);
        end
    end
    
%the weights of all the base models  
orig_W=zeros(num,k);  
%the weights of all the group nodes
W=zeros(num,k*class);

%compute the weights based on Eq. 6 for all the models, and then extend
%them to all the group nodes
for i=1:num
    weight=zeros(k,k);
    for j=1:k
        clabel=pM(i,j);
        ind1=(j-1)*class+clabel;
        for h=j+1:k
            clabel=pM(i,h);
            ind2=(h-1)*class+clabel;
            weight(j,h)=gW(ind1,ind2);
        end
    end
    weight=weight+weight';
    orig_W(i,:)=sum(weight)/(k-1);
    for j=1:k
    W(i,(j-1)*class+clabel)=orig_W(i,j); 
    end
end

 