function [weight,w_prob]=weighting(CLU,prob)
%
%  weighting: compute local model weights according to the similarity
%             between the model and the clustering structure. (works for
%             binary classification problems)
%  Input: 
%       CLU- a column vector where each element represents the cluster
%            membership (0 or 1).
%       prob- a n by 2 matrix where n is the number of test examples, 
%             containing the predictions made by a classification model.  
%             prob(i,1)- the probability of i-th example belonging to class
%             0; prob(i,2)- the probability of i-th example belonging to
%             class 1.
%  Output:           
%       weight- a colum vector where each element represents the model
%               weight at the test example.
%       w_prob- the model's predictions weighted by its local weights
%
%==========================================================================
%
%
% An example:
%
%
%       directory='results'; % the result folder
% 
%       clusterfile=[directory,'/cluster'];
%       CLU=load(clusterfile); % the clustering results
%
%       num=length(CLU);
%       W=zeros(num,3);
%       en_prob=zeros(num,2); % initialization
%       
%       for i=1:3 % compute model weights
%       pfile=[directory,'/predict',num2str(i)];
%       prob=load(pfile);
%       [weight,w_prob]=weighting(CLU,prob);
%       en_prob=en_prob+w_prob;
%       W(:,i)=weight;
%       end
% 
%       en_prob=en_prob./repmat(sum(en_prob,2),1,2); % the ensemble output
%
%       enfile=[directory,'/ensemble'];
%       csvwrite(enfile,en_prob); %output the ensemble predictions
%
%       wfile=[directory,'/weight_matrix'];
%       csvwrite(wfile,W); %output the weights
%
%
%
%
num=length(CLU);
CLA=zeros(length(CLU),1);
id=find(prob(:,2)>0.5);
CLA(id)=1;


for i=1:num
    index=[1:i-1,i+1:num];
    ulabel=CLU(i);
    alabel=CLA(i);
    id1=find(CLU(index)==ulabel);
    id2=find(CLA(index)==alabel);
    %the percentage of common neighbors
    weight(i)=length(intersect(id1,id2))/length(union(id1,id2));
end
w_prob=prob.*repmat(weight',1,2);