import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MyMultiplier extends HttpServlet {
	/* Overrides doGet coming with HttpServlet */
	public void doGet(HttpServletRequest req, HttpServletResponse res)
			throws ServletException, IOException {
		res.setContentType("text/html");
		/* By having set content to text/html PrintWriter encodes accordingly */
		PrintWriter out = res.getWriter();

		String timesStr = getInitParameter("times");
		double times = 0;
		try {
			times = Double.parseDouble(timesStr);
		} catch (NumberFormatException e) {
			out.println("Error parsing init parameter <times> as a double: "
					+ timesStr);
			return;
		}

		out.println("<html><head><title>Multiply by " + timesStr
				+ "</title></head></html><body>");

		String paramStr = req.getParameter("num");
		try {
			double result = times * Double.parseDouble(paramStr);
			out.println(paramStr + " * " + timesStr + " = " + result);
		} catch (NumberFormatException e) {
			out.println("Error parsing request parameter <num> as a double: "
					+ paramStr);
		}

		out.println("</body></html>");
	}
}