package dataentry.forms;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class StudentFormInsertUpdate extends ActionForm {

	private static final long serialVersionUID = 1L;

	private String id = null;
	private String first = null;
	private String middle = null;
	private String last = null;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getFirst() {
		return first;
	}

	public void setFirst(String first) {
		this.first = first;
	}

	public String getMiddle() {
		return middle;
	}

	public void setMiddle(String middle) {
		this.middle = middle;
	}

	public String getLast() {
		return last;
	}

	public void setLast(String last) {
		this.last = last;
	}

	/**
	 * Reset all properties to their default values.
	 * 
	 * @param mapping
	 *            The mapping used to select this instance
	 * @param request
	 *            The servlet request we are processing
	 */
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		setId(null);
		setFirst(null);
		setMiddle(null);
		setLast(null);
	}

	/**
	 * Validate the input data. If validation fails, then report the errors in
	 * students.jsp, and specifically where <html:errors/> is located.
	 * 
	 * @param mapping
	 *            The mapping used to select this instance
	 * @param request
	 *            The servlet request we are processing
	 */
	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest request) {

		ActionErrors errors = new ActionErrors();

		if ((id == null) || (id.length() < 1))
			errors.add("idMsgTag1",
					new ActionMessage("errors.required", "UBID"));
		else
			try {
				Integer.parseInt(id);
			} catch (NumberFormatException ex) {
				errors.add("idMsgTag2", new ActionMessage("errors.notanumber",
						"UBID"));
			}

		if ((first == null) || (first.length() < 1))
			errors.add("firstMsgTag1", new ActionMessage("errors.required",
					"First Name"));

		if ((last == null) || (last.length() < 1))
			errors.add("lastMsgTag1", new ActionMessage("errors.required",
					"Last Name"));

		return errors;
	}

}
