package dataentry.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import dataentry.db.DBException;
import dataentry.forms.StudentFormInsertUpdate;
import dataentry.model.StudentModel;

public class UpdateStudentAction extends Action {

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws DBException {

		// cast the form
		StudentFormInsertUpdate iForm = (StudentFormInsertUpdate) request.getSession().getAttribute("studentFormInsertUpdate");
		// update the student
		StudentModel.updateStudent(iForm);
		// reset the form
		iForm.reset(mapping, request);

		return mapping.findForward("success");
	}
}
