package app;

/**
 * Manifest constants for this application.
 * 
 * @author Craig R. McClanahan
 * @author Ted Husted
 * @version $Revision: 1.1.1.1 $ $Date: 2002/08/15 15:50:55 $
 */

public final class Constants {

	/**
	 * The package name for this application.
	 */
	public static final String Package = "app";

	/**
	 * The session scope attribute under which the Username for the currently
	 * logged in user is stored.
	 */
	public static final String USER_KEY = "user";

	/**
	 * The token that represents a nominal outcome in an ActionForward.
	 */
	public static final String SUCCESS = "success";

	/**
	 * The token that represents the logon activity in an ActionForward.
	 */
	public static final String LOGON = "logon";

	/**
	 * The token that represents the welcome activity in an ActionForward.
	 */
	public static final String WELCOME = "welcome";

	/**
	 * The value to indicate debug logging.
	 */
	public static final int DEBUG = 1;

	/**
	 * The value to indicate normal logging.
	 */
	public static final int NORMAL = 0;

}
