package app.forms;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

import app.model.Model;

public class Bid extends ActionForm {

	private static final long serialVersionUID = 1L;

	private String itemID;
	private Integer bidPrice;

	public void setItemID(String itemID) {
		this.itemID = itemID;
	}

	public String getItemID() {
		return itemID;
	}

	public void setBidPrice(Integer bidPrice) {
		this.bidPrice = bidPrice;
	}

	public Integer getBidPrice() {
		return bidPrice;
	}

	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();
		if (itemID == null || itemID.length() == 0 || !Model.validID(itemID)) {
			errors.add("itemId", new ActionMessage("errors.detail",
					"Invalid item ID. Please input again."));
		}
		return errors;
	}
}
