package ora.jwsnut.chapter3.SAAJdemoservice;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import ora.jwsnut.saaj.SAAJServlet;

/**
 * A servlet that uses SAAJ attachments to 
 * serve an image to a client.
 */
public class SAAJDemoServlet extends SAAJServlet {
    
    // The XML Schema namespace
    private static final String XMLSCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    
    // The XML Schema instance namespace
    private static final String XMLSCHEMA_INSTANCE_URI = 
                                        "http://www.w3.org/2001/XMLSchema-instance";

    // Namespace prefix for XML Schema
    private static final String XMLSCHEMA_PREFIX = "xsd";

    // Namespace prefix for XML Schema instance
    private static final String XMLSCHEMA_INSTANCE_PREFIX = "xsi";    
    
    // The namespace prefix used for SOAP encoding
    private static final String SOAP_ENC_PREFIX = "SOAP-ENC";
    
    // The URI used to qualify elements for this service
    private static final String SERVICE_URI = "urn:jwsnut.SAAJdemoservice";
    
    // The namespace prefix used in elements for this service
    private static final String SERVICE_PREFIX = "tns";
    
    // MessageFactory for replies from this service
    private static MessageFactory messageFactory;
     
    // SOAPFactory for message pieces
    private static SOAPFactory soapFactory;
    
    // The name of the element used to request a image
    private static Name IMAGE_REQUEST_NAME;
    
    // The name of the element used to respond to a image request
    private static Name IMAGE_NAME;
    
    // The name of the attribute used to hold the image encoding
    //private static Name IMAGE_TYPE_ATTRIBUTE;
   
    // The name of the href attribute
    private static Name HREF_ATTRIBUTE;
 
    /**
     * Handles a received SOAP message.
     */
    public SOAPMessage onMessage(SOAPMessage message) throws SOAPException {
        if (messageFactory == null) {
            // Create all static data on first call
            messageFactory = MessageFactory.newInstance();
            soapFactory = SOAPFactory.newInstance();
            IMAGE_REQUEST_NAME = 
                        soapFactory.createName("ImageRequest", SERVICE_PREFIX, SERVICE_URI);
            IMAGE_NAME = soapFactory.createName("Image", SERVICE_PREFIX, SERVICE_URI);
       	    HREF_ATTRIBUTE = soapFactory.createName("href");
	}
        
        // Create the reply message and define the namespace
        // and encoding for the elements used in the reply.
        SOAPMessage reply = messageFactory.createMessage();
        SOAPEnvelope replyEnvelope = reply.getSOAPPart().getEnvelope();
        replyEnvelope.getHeader().detachNode();
        replyEnvelope.addNamespaceDeclaration(SERVICE_PREFIX, SERVICE_URI);
        replyEnvelope.addNamespaceDeclaration(SOAP_ENC_PREFIX, 
                                            SOAPConstants.URI_NS_SOAP_ENCODING);
        replyEnvelope.addNamespaceDeclaration(XMLSCHEMA_PREFIX, XMLSCHEMA_URI);
        replyEnvelope.addNamespaceDeclaration(XMLSCHEMA_INSTANCE_PREFIX, 
                                                        XMLSCHEMA_INSTANCE_URI);        
        replyEnvelope.setEncodingStyle(SOAPConstants.URI_NS_SOAP_ENCODING);
        SOAPBody replyBody = reply.getSOAPPart().getEnvelope().getBody();        
	handleImageRequest(reply);
        return reply;
    }
    
    /**
     * Handles a request for the image.
     */
    private void handleImageRequest(SOAPMessage reply) 
                                            throws SOAPException {
        // The reply body has a Image element and a nested item with
        // a reference to the image which is sent as an attachment                                                
        SOAPBody replyBody = reply.getSOAPPart().getEnvelope().getBody();
                
        SOAPBodyElement bodyElement = replyBody.addBodyElement(IMAGE_NAME);
        byte[] imageData = getImageData();
        if (imageData != null) {
                // Got the data - attach it.
                AttachmentPart attach = reply.createAttachmentPart();   
                attach.setDataHandler(new DataHandler(
                                        new ByteArrayDataSource("Image Data",
                                            imageData,
                                            "image/gif" )));
                attach.setContentId("ID0");
                reply.addAttachmentPart(attach);  

                // Add an element in the reply pointing to the attachment
                bodyElement.addChildElement("item").addAttribute(HREF_ATTRIBUTE, "cid:ID0"); 
                
            } else {
                // No data - this is a fault.
                // Clear the reply and install the fault
                reply.removeAllAttachments();
                bodyElement.detachNode();
                createFault(replyBody, "soap-env:Client.Title", "Unknown file",
                                        SERVICE_URI, "File not found");
                return;
            }
    }
    
    /**
     * Creates a fault in the reply body.
     */
    private void createFault(SOAPBody replyBody, String faultCode, String faultString,
                                String faultActor, String detailString) throws SOAPException {
                                    
        SOAPFault fault = replyBody.addFault();
        fault.setFaultCode(faultCode);
        fault.setFaultString(faultString);
        fault.setFaultActor(faultActor);
        if (detailString != null) {
            Name detailName = soapFactory.createName("DemoFaultDetail", SERVICE_PREFIX, SERVICE_URI);
            Detail detail = fault.addDetail();
            DetailEntry detailEntry = detail.addDetailEntry(detailName);
            detailEntry.addTextNode(detailString);
        }
    }
    private byte[] getImageData() {
        byte[] buffer = new byte[1024];
	String filename="/projects/Spring_2003/cse487/va8/test.GIF";
        try{
                FileInputStream is = new FileInputStream(filename);
                int count;
                if(is==null){
			throw new Exception("File Input Stream Null !");
                }
                else{
                        count = is.read(buffer, 0, 1024) ;
                }
        }
	catch(FileNotFoundException fe){
		System.out.println("File not found: "+filename); 
        } 
	catch(Exception e){
                System.out.println("Exception: " +e.getMessage());
		e.printStackTrace();
        }
        return buffer;
    }

}

/**
 * A private DataSource implementation that
 * allows byte streams of arbitrary types to
 * be associated with a DataHandler.
 */
class ByteArrayDataSource implements DataSource {

    private String contentType;
    
    private byte[] data; 
    
    private String name;
        
    ByteArrayDataSource(String name, byte[] data, String contentType) {
        this.name = name;
        this.data = data;
        this.contentType = contentType;
    }
    
    public String getContentType() {
        return contentType;
    }
    
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(data);
    }
    
    public String getName() {
        return name;
    }
    
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("ByteArrayDataSource cannot support getOutputStream()");
    }
}
