/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.callback;

import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceCallback;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.OperationProvider;
import org.globus.ogsa.ServiceData;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.xml.namespace.QName;

import java.rmi.RemoteException;


public class ProviderCallbackRecorder implements OperationProvider,
    GridServiceCallback {
    private ServiceData states;
    static Log logger =
        LogFactory.getLog(ProviderCallbackRecorder.class.getName());

    public void initialize(GridServiceBase base) throws GridServiceException {
        this.states = base.getServiceDataSet().create("callbackStates");
        base.getServiceDataSet().add(this.states);
    }

    public QName[] getOperations() {
        return new QName[0];
    }

    public void preCreate(GridServiceBase base) throws GridServiceException {
        this.states.addValue("preCreate");
    }

    public void postCreate(GridContext context) throws GridServiceException {
        this.states.addValue("postCreate");
    }

    public void activate(GridContext context) throws GridServiceException {
        this.states.addValue("activate");
        this.states.notifyChange();
    }

    public void deactivate(GridContext context) throws GridServiceException {
        this.states.addValue("deactivate");
        this.states.notifyChange();
    }

    public void preDestroy(GridContext context) throws GridServiceException {
        this.states.addValue("preDestroy");
        this.states.notifyChange();
    }
}
