/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.notification;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.NotificationProvider;
import org.globus.ogsa.ServiceProperties;

import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.xml.namespace.QName;

import java.rmi.RemoteException;


public class CounterNotificationImpl extends GridServiceImpl {
    int val = 0;
    NotificationProvider provider = null;

    public CounterNotificationImpl() {
        super("Sample Notification Counter");
    }

    public void postCreate(GridContext context) throws GridServiceException {
	super.postCreate(context);

	this.provider = (NotificationProvider) getProperty(
				ServiceProperties.NOTIFICATION_SOURCE
		        );
	this.provider.addTopic(
                "CounterUpdate",
                new QName(
                    "http://samples.globus.org/extension/counter",
                    "CounterDataType"
                )
	);
    }

    public int add(int val) throws RemoteException {
        this.val += val;
        notifyUpdate();

        return this.val;
    }

    public int subtract(int val) throws RemoteException {
        this.val -= val;
        notifyUpdate();

        return this.val;
    }

    private void notifyUpdate() {
        try {
            this.provider.notify(
                "CounterUpdate", CounterDataType.toElement(this.val)
            );
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getValue() throws RemoteException {
        return this.val;
    }
}
