/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.routable.master;

import org.globus.ogsa.impl.ogsi.FactoryProvider;
import org.globus.ogsa.FactoryCallback;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceCallback;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.router.ProxySetupHelper;
import org.globus.ogsa.utils.MessageUtils;

import org.gridforum.ogsi.ExtensibilityType;

import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.rmi.RemoteException;


public class MasterCounterFactory implements FactoryCallback,
    GridServiceCallback {
    private static Log logger = LogFactory.getLog(MasterCounterFactory.class);
    private GridServiceBase base;

    public void initialize(GridServiceBase base) throws GridServiceException {
        this.base = base;
    }

    public GridServiceBase createServiceObject(ExtensibilityType creation)
        throws GridServiceException {
        // Throw a RedirectException 
        String invocationId =
            (String) MessageContext.getCurrentContext().getProperty(
                ServiceProperties.INVOCATION_ID
            );
        throw new HostingEnvRedirectException(
            invocationId,
            new GridContext(MessageContext.getCurrentContext(), this.base)
        );
    }

    public void preDestroy(GridContext context) throws GridServiceException {
        ProxySetupHelper.destroyProxy(this.base);
    }

    public void postCreate(GridContext context) throws GridServiceException {
        // these two calls are what make this a proxy service  
        ProxySetupHelper.setupProxy(this.base);
    }

    public void activate(GridContext context) throws GridServiceException {
    }

    public void deactivate(GridContext context) throws GridServiceException {
    }

    public void preCreate(GridServiceBase base) throws GridServiceException {
    }
}
