/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.secure;

import org.globus.ogsa.impl.samples.counter.notification.CounterDataType;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.NotificationProvider;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.samples.counter.CounterPortType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.xml.namespace.QName;

import java.rmi.RemoteException;

import java.util.Map;


public class CounterImpl {
    private static Log logger = LogFactory.getLog(CounterImpl.class.getName());
    private int val = 0;
    NotificationProvider source;

    public CounterImpl(ServiceProperties properties) throws Exception {
        source =
            (NotificationProvider) properties.getProperty(
                ServiceProperties.NOTIFICATION_SOURCE
            );
        source.addTopic(
            "CounterUpdate",
            new QName(
                "http://samples.globus.org/extension/counter", "CounterDataType"
            )
        );
        logger.debug("Created Counter " + this.hashCode());
    }

    public int add(int val) throws RemoteException {
        logger.debug("Add " + val + " to Counter " + this.hashCode());
        this.val = this.val + val;

        return this.val;
    }

    public int subtract(int val) throws RemoteException {
        logger.debug("Subtract " + val + " from Counter " + this.hashCode());
        this.val = this.val - val;

        return this.val;
    }

    public int getValue() throws RemoteException {
        logger.debug("Get " + this.val + " from Counter ");

        return this.val;
    }

    public void preDestroy() throws Exception {
        logger.debug("Counter " + this.hashCode() + "destroyed");
    }

    public void sendNotification(Map notifyProps) {
        try {
            this.source.notify(
                "CounterUpdate", CounterDataType.toElement(this.val),
                notifyProps
            );
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
