/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.google;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.samples.google.GoogleSearchPort;
import org.globus.ogsa.samples.google.GoogleSearchResult;
import org.globus.ogsa.samples.google.GoogleSearchServiceLocator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.net.URL;

import java.rmi.RemoteException;


public class GoogleImpl extends GridServiceImpl implements GoogleSearchPort {
    private GoogleSearchServiceLocator googleService;
    private GoogleSearchPort googlePort;
    String mykey = "wMFVucygk0f60Sw+/NjpM3TXw4lGb33P";
    static Log logger = LogFactory.getLog(GoogleImpl.class.getName());

    public GoogleImpl() {
        super("Google Search");

        try {
            this.googleService = new GoogleSearchServiceLocator();
            this.googlePort =
                this.googleService.getGoogleSearchPort(
                    new URL("http://api.google.com:80/search/beta2")
                );
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] doGetCachedPage(
        String key,
        String url
    ) throws java.rmi.RemoteException {
        return (this.googlePort.doGetCachedPage(key, url));
    }

    public String doSpellingSuggestion(
        String key,
        String phrase
    ) throws java.rmi.RemoteException {
        return (this.googlePort.doSpellingSuggestion(key, phrase));
    }

    public GoogleSearchResult doGoogleSearch(
        String key,
        String q,
        int start,
        int maxResults,
        boolean filter,
        String restrict,
        boolean safeSearch,
        String lr,
        String ie,
        String oe
    ) throws java.rmi.RemoteException {
        return (GoogleSearchResult) (
            this.googlePort.doGoogleSearch(
                key, q, start, maxResults, filter, restrict, safeSearch, lr, ie,
                oe
            )
        );
    }
}
