/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.loader;

import org.globus.ogsa.impl.core.service.ServicePropertiesImpl;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.repository.ServiceLoader;
import org.globus.ogsa.repository.ServiceLoaderException;
import org.globus.ogsa.repository.ServiceNode;

import java.io.File;
import java.io.FileOutputStream;


public class SimpleFileLoader implements ServiceLoader {
    public boolean load(String service) throws ServiceLoaderException {
        String serviceFile = getServiceFile(service);
        File file = new File(serviceFile);

        if (!file.exists()) {
            return false;
        }

        ServicePropertiesImpl props = new ServicePropertiesImpl();
        props.setProperty(
            ServiceProperties.DEACTIVATED_TRANSIENT, Boolean.TRUE
        );
        ServiceNode.getRootNode().bind(service, props);

        return true;
    }

    public void store(String service) throws ServiceLoaderException {
        String serviceFile = getServiceFile(service);
        FileOutputStream file = null;

        try {
            file = new FileOutputStream(serviceFile);
            file.flush();
        } catch (Exception e) {
            throw new ServiceLoaderException(e);
        } finally {
            try {
                if (file != null) {
                    file.close();
                }
            } catch (Exception e) {
            }
        }
    }

    public void remove(String service) throws ServiceLoaderException {
        String serviceFile = getServiceFile(service);
        File file = new File(serviceFile);
        file.delete();
    }

    private String getServiceFile(String service) 
            throws ServiceLoaderException {
        String serviceFile = service.replace('/', '.');

        try {
            File dir =
                new File("temp");
            dir.mkdir();
            serviceFile = dir.getName() + File.separator + serviceFile;
        } catch (Exception e) {
            throw new ServiceLoaderException(e);
        }

        return serviceFile;
    }
}
