/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.weather.client;

import org.globus.ogsa.samples.weather.WeatherPortType;
import org.globus.ogsa.samples.weather.service.WeatherServiceLocator;

import java.net.URL;


public class SetZipCode {
    public static void main(String[] args) {
        String uri;
        WeatherServiceLocator weatherService = new WeatherServiceLocator();

        if (args.length < 2) {
            System.err.println("usage: SetZipCode <zipCode> <uri>");

            return;
        }

        try {
            WeatherPortType weather =
                weatherService.getWeatherPort(new URL(args[1]));
            float temp = weather.setZipCode(args[0]);
            System.out.println(
                "Successfully set zipcode to: " + args[0] +
                " and got back temperature: " + temp
            );
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
