/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.any;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.utils.AnyHelper;

import org.gridforum.ogsi.ExtensibilityType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.rmi.RemoteException;

public class AnyImpl extends GridServiceImpl {
    static Log logger = LogFactory.getLog(AnyImpl.class.getName());
    protected ExtensibilityType any = new ExtensibilityType();
    private boolean stringMapping = false;
    private boolean elementMapping = false;

    public AnyImpl() {
        super("Sample Any");
    }

    public void postCreate(GridContext context) throws GridServiceException {
	super.postCreate(context);

        String serialization =
            System.getProperty("org.globus.ogsa.any.sample.serialization");

        if (
            (serialization != null) &&
                (serialization.equalsIgnoreCase("string"))
        ) {
            stringMapping = true;
        } else if (
            (serialization != null) &&
                (serialization.equalsIgnoreCase("element"))
        ) {
            elementMapping = true;
        }
    }

    public void setAny(ExtensibilityType any) throws RemoteException {
        this.any = any;

        if (stringMapping) {
            AnyHelper.getAsRawString(any);
        } else if (elementMapping) {
            try {
                AnyHelper.getAsParentElement(any);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        if (any == null) {
            return;
        }

        if (logger.isDebugEnabled()) {
            String elementString = AnyHelper.getAsString(any);
            logger.debug(elementString);
        }
    }

    public ExtensibilityType getAny() throws RemoteException {
        return this.any;
    }
}
