/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.complex;

import org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl;
import org.globus.ogsa.samples.complex.array.ArrayInnerClass;
import org.globus.ogsa.samples.complex.array.ArrayOuterClass;
import org.globus.ogsa.samples.complex.array.ArrayServicePortType;


public class NestedArrayServiceImpl extends PersistentGridServiceImpl
    implements ArrayServicePortType {
    public NestedArrayServiceImpl() {
        super("Array Service Implementation");
    }

    public ArrayOuterClass create() {
        ArrayOuterClass oClass = new ArrayOuterClass();
        ArrayInnerClass[] iClasses = new ArrayInnerClass[2];
        iClasses[0] = new ArrayInnerClass();
        iClasses[0].setS("first inner class");
        iClasses[0].setI(0);
        iClasses[1] = new ArrayInnerClass();
        iClasses[1].setS("second inner class");
        iClasses[1].setI(1);
        oClass.setIClasses(iClasses);
        oClass.setField(1);

        return oClass;
    }

    public void call(ArrayOuterClass oClass) {
        System.out.println(
            oClass.getIClasses()[0].getS() + " " +
            oClass.getIClasses()[1].getS()
        );
    }
}
