/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.complex;

import org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl;
import org.globus.ogsa.samples.complex.nested.InnerClass;
import org.globus.ogsa.samples.complex.nested.OuterClass;
import org.globus.ogsa.samples.complex.nested.ServicePortType;


public class NestedServiceImpl extends PersistentGridServiceImpl
    implements ServicePortType {
    public NestedServiceImpl() {
        super("Nested Object Service Implementation");
    }

    public OuterClass create() {
        OuterClass oClass = new OuterClass();
        InnerClass iClass = new InnerClass();
        iClass.setS("string");
        iClass.setI(0);
        oClass.setIClass(iClass);
        oClass.setField(0);

        return oClass;
    }

    public void call(OuterClass oClass) {
        System.out.println(
            oClass.getIClass().getS() + " " + oClass.getIClass().getI()
        );
    }
}
