/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.delegation;

import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.OperationProvider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.xml.namespace.QName;

import java.rmi.RemoteException;


public class CounterProvider implements OperationProvider {
    private static String COUNTER_NS = "http://ogsa.globus.org/samples/counter";
    public static QName[] operations =
        new QName[] {
            new QName(COUNTER_NS, "add"), new QName(COUNTER_NS, "subtract"),
            new QName(COUNTER_NS, "getValue")
        };
    private int val = 0;
    static Log logger = LogFactory.getLog(CounterProvider.class.getName());

    public QName[] getOperations() {
        return operations;
    }

    public void initialize(GridServiceBase base) throws GridServiceException {
    }

    public CounterProvider() {
        logger.debug("Created Counter " + this.hashCode());
    }

    public int add(int val) throws RemoteException {
        logger.debug("Add " + val + " to Counter " + this.hashCode());
        this.val = this.val + val;

        return this.val;
    }

    public int subtract(int val) throws RemoteException {
        logger.debug("Subtract " + val + " from Counter " + this.hashCode());
        this.val = this.val - val;

        return this.val;
    }

    public int getValue() throws RemoteException {
        logger.debug("Get " + this.val + " from Counter ");

        return this.val;
    }
}
