/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.counter.routable.master;

import org.globus.ogsa.impl.security.authentication.Constants;
import org.globus.ogsa.impl.security.authorization.NoAuthorization;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.core.admin.AdminServicePortType;
import org.globus.ogsa.core.admin.service.AdminServiceGridLocator;
import org.globus.ogsa.router.HostStarter;
import org.globus.ogsa.router.RedirectException;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.wsdl.SymbolTable;

import org.gridforum.ogsi.HandleType;

import javax.xml.rpc.Stub;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

import java.rmi.RemoteException;

import java.security.AllPermission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;


// Class used by the router to obtain a target URL if not URL is specified in 
// configuration
public class HostingEnvStarter implements HostStarter, Runnable {
    GridContext gridContext = null;
    String invocationId = null;
    HashMap portMap = new HashMap();
    ArrayList stopHandles = new ArrayList();
    ArrayList deleteDirs = new ArrayList();
    private int attempts = 10;
    final String testClasspath = "OGSATESTCP";

    public void run() {
        for (Iterator iterator = stopHandles.iterator(); iterator.hasNext();) {
            String handle = (String) iterator.next();
            shutdown(new HandleType(handle));
        }

        try {
            Thread.currentThread().sleep(10000);
        } catch (Exception e) {
            e.printStackTrace();
        }

        for (Iterator iterator = deleteDirs.iterator(); iterator.hasNext();) {
            File file = (File) iterator.next();
            File[] files = file.listFiles();

            for (int i = 0; i < files.length; i++) {
                System.out.println(
                    "delete file " + file.getName() + "/" + files[i].getName()
                );
                files[i].delete();
            }

            System.out.println("delete dir " + file.getName());
            file.delete();
        }
    }

    private void shutdown(HandleType handle) {
        try {
            AdminServiceGridLocator locator = new AdminServiceGridLocator();
            AdminServicePortType admin = locator.getAdminPort(handle);
            ((Stub) admin)._setProperty(Constants.GSI_SEC_CONV, 
					Constants.SIGNATURE);
	    ((Stub) admin)._setProperty(Constants.AUTHORIZATION, 
					NoAuthorization.getInstance());
            admin.shutdown(false);
        } catch (Exception e) {
            System.err.println(MessageUtils.toString(e));
        }
    }

    public HostingEnvStarter() {
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    public String getUserName(Exception e) {
	return (e instanceof HostingEnvRedirectException) ?
	    ((HostingEnvRedirectException)e).getInvocationId() :
	    null;
    }

    public void targetCreated(String localServicePath,
			      String remoteTargetUrl,
			      Exception e) {
    }

    public String startProxyTarget(
        String localServicePath,
        String targetEndpoint,
        Exception cause
    ) throws Exception {
        if (cause instanceof HostingEnvRedirectException) {
            // A Redirect Exception has been thrown by the Master service
            // An attempt is made to forward the call the local service, 
            // but a new UHE is not started
            gridContext =
                ((HostingEnvRedirectException) cause).getGridContext();
            invocationId =
                ((HostingEnvRedirectException) cause).getInvocationId();

            if (invocationId != null) {
                int instancePos = invocationId.indexOf("-");

                if (instancePos != -1) {
                    invocationId = invocationId.substring(0, instancePos);
                }
            }

            String targetUrl = createTargetUrl();
            System.out.println("targetUrl " + targetUrl);

            return targetUrl;
        } else if (isLHEdownException(cause)) {
            // An attempt was made to reach the local service and failed and a 
            // UHE is started up
            System.out.println(
                "An attempt was made to reach the local service" +
                " and failed and a UHE is started up"
            );

            //Create a directory using the invocatin id.
            System.out.println("Invocation id for dir  " + invocationId);

            File uheDir = new File(invocationId);

            if (uheDir.mkdir()) {
                this.deleteDirs.add(uheDir);
            }

            // Copy server config to the new directory
            String srcServerConfigFileName = "uhe-server-config.wsdd";
            String destServerConfigFileName = "server-config.wsdd";
            PrintWriter destFileWriter =
                new PrintWriter(
                    new FileWriter(
                        invocationId + File.separator +
                        destServerConfigFileName
                    )
                );

            File srcServerConfigFile = null;
            String cfgPath = ContainerConfig.getConfig().getConfigPath();
            srcServerConfigFile =
                ((cfgPath != null) && (cfgPath.length() > 0))
                ? new File(cfgPath, srcServerConfigFileName)
                : new File(srcServerConfigFileName);

            BufferedReader srcFileReader =
                new BufferedReader(new FileReader(srcServerConfigFile));
            String buffer;

            while ((buffer = srcFileReader.readLine()) != null) {
                destFileWriter.write(buffer + "\n");
            }

            destFileWriter.close();

            // Extract port number
            int colonPos = targetEndpoint.indexOf(":", 7);
            String portString =
                targetEndpoint.substring(
                    colonPos + 1, targetEndpoint.indexOf("/", colonPos)
                );
            System.out.println("Port string is " + portString);

            // attempt to read classpath for test, if empty, default to
            // standard java classpath
            System.out.println("getting system property " + testClasspath);

            String classpathEnv = System.getProperty(testClasspath);
            boolean ignoreEnv = false;
            System.out.println("Test class path " + classpathEnv);
            String classpathParam = "";
            if (System.getProperty("org.globus.ogsa.noenv") != null) {
                System.out.println("Disabling env");
                classpathParam = "-classpath \"" + classpathEnv +
                    "\" ";
                ignoreEnv = true;
            }


            if ((classpathEnv == null) || (classpathEnv.trim().equals(""))) {
                classpathParam =
                    "-classpath \"" + System.getProperty("java.class.path") +
                    "\" ";
            }

            // check for web.root, if not set, use current dir
            String webRoot = System.getProperty("web.root");

            if ((webRoot == null) || (webRoot.trim().equals(""))) {
                webRoot = ".." + File.separator;
            }

            // Start up container on the new port
            String command =
                "java " + classpathParam + SymbolTable.getDisableProperty() +
                " -Dorg.globus.ogsa.server.webroot=" + webRoot +
                " org.globus.ogsa.server.ServiceContainer -p " + portString +
                " -lazy";
            System.out.println("Command is " + command);

            String[] envArray = null;

            if (classpathEnv != null && !ignoreEnv) {
                String envVar = "CLASSPATH=" + classpathEnv;
                envArray = new String[] { envVar };
            }

            String stopHandle =
                "http://127.0.0.1:" + portString + "/" +
                ContainerConfig.getOgsiLocation() + "core/admin/AdminService";
            this.stopHandles.add(stopHandle);
            System.out.println("Stop handle is " + stopHandle);

            Process proc = Runtime.getRuntime().exec(command, envArray, uheDir);
            StreamThread error =
                new StreamThread(
                    proc.getErrorStream(),
                    invocationId + File.separator + "error.txt"
                );
            StreamThread output =
                new StreamThread(
                    proc.getInputStream(),
                    invocationId + File.separator + "out.txt"
                );
            error.start();
            output.start();

            HandleType pingHandle = new HandleType(stopHandle);
            AdminServiceGridLocator locator = new AdminServiceGridLocator();
            int i = 0;

            while (i < this.attempts) {
                try {
                    AdminServicePortType admin =
                        locator.getAdminPort(pingHandle);
                    ((Stub) admin)._setProperty(Constants.GSI_SEC_CONV,
						Constants.SIGNATURE);
		    ((Stub) admin)._setProperty(Constants.AUTHORIZATION,
						NoAuthorization.getInstance());
                    admin.ping();

                    break;
                } catch (Exception e) {
                    i++;
                    System.err.println("Ping failed attempt " + i);

                    if (i == this.attempts) {
                        this.stopHandles.remove(stopHandle);
                        this.deleteDirs.remove(uheDir);
                        throw new RemoteException(
                            "Failed to ping local hosting" + " environment: " +
                            pingHandle
                        );
                    }
                }

                Thread.currentThread().sleep(5000);
            }

            return targetEndpoint;
        } else {
            System.out.println(
                "Unknown exception in " + "HostingEnvironmentStarter"
            );
            throw cause;
        }
    }

    // Create target URL 
    private String createTargetUrl() throws Exception {
        return "http://localhost:" + getPort() +
        "/ogsa/services/samples/counter/routable/" +
        "LocalCounterFactoryService";
    }

    // Must return the same port for the same name accross invocations of
    // the whole system
    private int getPort() throws Exception {
        if (gridContext == null) {
            System.out.println("Grid context is null");
        } else {
            System.out.println("Grid context is not null");
        }

        System.out.println("Invocation id is " + invocationId);

        Integer portNumber = (Integer) portMap.get(invocationId);

        if (portNumber == null) {
            ServerSocket socket = new ServerSocket(0);
            portNumber = new Integer(socket.getLocalPort());
            socket.close();
            portMap.put(invocationId, portNumber);
        }

        return portNumber.intValue();
    }

    // Returns true if exception says that the LocalHostingEnvironment 
    // can't be reached 
    private boolean isLHEdownException(Throwable exc) {
        if (exc == null) {
            return false;
        }

        if (
            exc instanceof UnknownHostException ||
                exc instanceof SocketException
        ) {
            return true;
        }

        return isLHEdownException(
            RedirectException.getNextChainedException(exc)
        );
    }
}


class StreamThread extends Thread {
    InputStream stream;
    PrintWriter out;

    StreamThread(
        InputStream stream,
        String filename
    ) throws Exception {
        FileWriter writer = new FileWriter(filename);
        this.out = new PrintWriter(writer, true);
        this.stream = stream;
    }

    public void run() {
        try {
            BufferedReader reader =
                new BufferedReader(new InputStreamReader(stream));
            String message = reader.readLine();

            while (message != null) {
                out.println(message);
                message = reader.readLine();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                out.close();
            } catch (Exception e) {
            }
        }
    }
}
