/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.serialization;

import org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl;
import org.globus.ogsa.samples.serialization.SerializationPortType;
import org.globus.ogsa.samples.serialization.IntArrayType;
import org.globus.ogsa.samples.serialization.StringArrayType;
import org.globus.ogsa.samples.serialization.CustomArrayType;


import java.rmi.RemoteException;


public class SerializationImpl extends PersistentGridServiceImpl 
                               implements SerializationPortType {

    public SerializationImpl() {
        super("Serialization Sample");
    }

    public IntArrayType echoInts(IntArrayType ints) throws RemoteException {
        return ints;
    }

    public StringArrayType echoStrings(StringArrayType strings) 
            throws RemoteException {
        return strings;        
    }

    public CustomArrayType echoCustoms(CustomArrayType customs) 
            throws java.rmi.RemoteException {
        return customs;
    }
}
