/*
This file is licensed under the terms of the Globus Toolkit Public
License, found at http://www.globus.org/toolkit/download/license.html.
*/
package org.globus.ogsa.impl.samples.weather;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.samples.weather.WeatherPortType;
import org.globus.ogsa.samples.xmethods.TemperaturePortType;
import org.globus.ogsa.samples.xmethods.TemperatureServiceLocator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.net.URL;

import java.rmi.RemoteException;


public class WeatherImpl extends GridServiceImpl implements WeatherPortType {
    private String zipCode = "60439";
    private TemperatureServiceLocator temperatureService;
    private TemperaturePortType temperaturePort;
    static Log logger = LogFactory.getLog(WeatherImpl.class.getName());

    public WeatherImpl() {
        super("Sample Weather Service");

        try {
            this.temperatureService = new TemperatureServiceLocator();
            this.temperaturePort =
                this.temperatureService.getTemperaturePort(
                    new URL(
                        "http://services.xmethods.net/soap/servlet/rpcrouter"
                    )
                );
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public float setZipCode(String zipCode) throws RemoteException {
        this.zipCode = zipCode;

        return getTemp();
    }

    public float getTemp() throws RemoteException {
        logger.debug("Getting temp for zipcode: " + zipCode);

        return this.temperaturePort.getTemp(this.zipCode);
    }
}
